import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS ElastiCache
*/
export interface DataAwsElasticacheReplicationGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/elasticache_replication_group#replication_group_id DataAwsElasticacheReplicationGroup#replication_group_id}
    */
    readonly replicationGroupId: string;
}
export interface DataAwsElasticacheReplicationGroupLogDeliveryConfiguration {
}
export declare function dataAwsElasticacheReplicationGroupLogDeliveryConfigurationToTerraform(struct?: DataAwsElasticacheReplicationGroupLogDeliveryConfiguration): any;
export declare class DataAwsElasticacheReplicationGroupLogDeliveryConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsElasticacheReplicationGroupLogDeliveryConfiguration | undefined;
    set internalValue(value: DataAwsElasticacheReplicationGroupLogDeliveryConfiguration | undefined);
    get destination(): string;
    get destinationType(): string;
    get logFormat(): string;
    get logType(): string;
}
export declare class DataAwsElasticacheReplicationGroupLogDeliveryConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsElasticacheReplicationGroupLogDeliveryConfigurationOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/elasticache_replication_group aws_elasticache_replication_group}
*/
export declare class DataAwsElasticacheReplicationGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_elasticache_replication_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/elasticache_replication_group aws_elasticache_replication_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsElasticacheReplicationGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsElasticacheReplicationGroupConfig);
    get arn(): string;
    get authTokenEnabled(): cdktf.IResolvable;
    get automaticFailoverEnabled(): cdktf.IResolvable;
    get configurationEndpointAddress(): string;
    get description(): string;
    get id(): string;
    private _logDeliveryConfiguration;
    get logDeliveryConfiguration(): DataAwsElasticacheReplicationGroupLogDeliveryConfigurationList;
    get memberClusters(): string[];
    get multiAzEnabled(): cdktf.IResolvable;
    get nodeType(): string;
    get numCacheClusters(): number;
    get numNodeGroups(): number;
    get numberCacheClusters(): number;
    get port(): number;
    get primaryEndpointAddress(): string;
    get readerEndpointAddress(): string;
    get replicasPerNodeGroup(): number;
    get replicationGroupDescription(): string;
    private _replicationGroupId?;
    get replicationGroupId(): string;
    set replicationGroupId(value: string);
    get replicationGroupIdInput(): string | undefined;
    get snapshotRetentionLimit(): number;
    get snapshotWindow(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-elasticache-replication-group.d.ts.map