import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Elastic Beanstalk
*/
export interface DataAwsElasticBeanstalkApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/elastic_beanstalk_application#name DataAwsElasticBeanstalkApplication#name}
    */
    readonly name: string;
}
export interface DataAwsElasticBeanstalkApplicationAppversionLifecycle {
}
export declare function dataAwsElasticBeanstalkApplicationAppversionLifecycleToTerraform(struct?: DataAwsElasticBeanstalkApplicationAppversionLifecycle): any;
export declare class DataAwsElasticBeanstalkApplicationAppversionLifecycleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsElasticBeanstalkApplicationAppversionLifecycle | undefined;
    set internalValue(value: DataAwsElasticBeanstalkApplicationAppversionLifecycle | undefined);
    get deleteSourceFromS3(): cdktf.IResolvable;
    get maxAgeInDays(): number;
    get maxCount(): number;
    get serviceRole(): string;
}
export declare class DataAwsElasticBeanstalkApplicationAppversionLifecycleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsElasticBeanstalkApplicationAppversionLifecycleOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/elastic_beanstalk_application aws_elastic_beanstalk_application}
*/
export declare class DataAwsElasticBeanstalkApplication extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_elastic_beanstalk_application";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/elastic_beanstalk_application aws_elastic_beanstalk_application} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsElasticBeanstalkApplicationConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsElasticBeanstalkApplicationConfig);
    private _appversionLifecycle;
    get appversionLifecycle(): DataAwsElasticBeanstalkApplicationAppversionLifecycleList;
    get arn(): string;
    get description(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-elastic-beanstalk-application.d.ts.map