import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Elastic Transcoder
*/
export interface ElastictranscoderPipelineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#aws_kms_key_arn ElastictranscoderPipeline#aws_kms_key_arn}
    */
    readonly awsKmsKeyArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#input_bucket ElastictranscoderPipeline#input_bucket}
    */
    readonly inputBucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#name ElastictranscoderPipeline#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#output_bucket ElastictranscoderPipeline#output_bucket}
    */
    readonly outputBucket?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#role ElastictranscoderPipeline#role}
    */
    readonly role: string;
    /**
    * content_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#content_config ElastictranscoderPipeline#content_config}
    */
    readonly contentConfig?: ElastictranscoderPipelineContentConfig;
    /**
    * content_config_permissions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#content_config_permissions ElastictranscoderPipeline#content_config_permissions}
    */
    readonly contentConfigPermissions?: ElastictranscoderPipelineContentConfigPermissions[] | cdktf.IResolvable;
    /**
    * notifications block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#notifications ElastictranscoderPipeline#notifications}
    */
    readonly notifications?: ElastictranscoderPipelineNotifications;
    /**
    * thumbnail_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#thumbnail_config ElastictranscoderPipeline#thumbnail_config}
    */
    readonly thumbnailConfig?: ElastictranscoderPipelineThumbnailConfig;
    /**
    * thumbnail_config_permissions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#thumbnail_config_permissions ElastictranscoderPipeline#thumbnail_config_permissions}
    */
    readonly thumbnailConfigPermissions?: ElastictranscoderPipelineThumbnailConfigPermissions[] | cdktf.IResolvable;
}
export interface ElastictranscoderPipelineContentConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#bucket ElastictranscoderPipeline#bucket}
    */
    readonly bucket?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#storage_class ElastictranscoderPipeline#storage_class}
    */
    readonly storageClass?: string;
}
export declare function elastictranscoderPipelineContentConfigToTerraform(struct?: ElastictranscoderPipelineContentConfigOutputReference | ElastictranscoderPipelineContentConfig): any;
export declare class ElastictranscoderPipelineContentConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastictranscoderPipelineContentConfig | undefined;
    set internalValue(value: ElastictranscoderPipelineContentConfig | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    resetBucket(): void;
    get bucketInput(): string | undefined;
    private _storageClass?;
    get storageClass(): string;
    set storageClass(value: string);
    resetStorageClass(): void;
    get storageClassInput(): string | undefined;
}
export interface ElastictranscoderPipelineContentConfigPermissions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#access ElastictranscoderPipeline#access}
    */
    readonly access?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#grantee ElastictranscoderPipeline#grantee}
    */
    readonly grantee?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#grantee_type ElastictranscoderPipeline#grantee_type}
    */
    readonly granteeType?: string;
}
export declare function elastictranscoderPipelineContentConfigPermissionsToTerraform(struct?: ElastictranscoderPipelineContentConfigPermissions | cdktf.IResolvable): any;
export interface ElastictranscoderPipelineNotifications {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#completed ElastictranscoderPipeline#completed}
    */
    readonly completed?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#error ElastictranscoderPipeline#error}
    */
    readonly error?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#progressing ElastictranscoderPipeline#progressing}
    */
    readonly progressing?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#warning ElastictranscoderPipeline#warning}
    */
    readonly warning?: string;
}
export declare function elastictranscoderPipelineNotificationsToTerraform(struct?: ElastictranscoderPipelineNotificationsOutputReference | ElastictranscoderPipelineNotifications): any;
export declare class ElastictranscoderPipelineNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastictranscoderPipelineNotifications | undefined;
    set internalValue(value: ElastictranscoderPipelineNotifications | undefined);
    private _completed?;
    get completed(): string;
    set completed(value: string);
    resetCompleted(): void;
    get completedInput(): string | undefined;
    private _error?;
    get error(): string;
    set error(value: string);
    resetError(): void;
    get errorInput(): string | undefined;
    private _progressing?;
    get progressing(): string;
    set progressing(value: string);
    resetProgressing(): void;
    get progressingInput(): string | undefined;
    private _warning?;
    get warning(): string;
    set warning(value: string);
    resetWarning(): void;
    get warningInput(): string | undefined;
}
export interface ElastictranscoderPipelineThumbnailConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#bucket ElastictranscoderPipeline#bucket}
    */
    readonly bucket?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#storage_class ElastictranscoderPipeline#storage_class}
    */
    readonly storageClass?: string;
}
export declare function elastictranscoderPipelineThumbnailConfigToTerraform(struct?: ElastictranscoderPipelineThumbnailConfigOutputReference | ElastictranscoderPipelineThumbnailConfig): any;
export declare class ElastictranscoderPipelineThumbnailConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElastictranscoderPipelineThumbnailConfig | undefined;
    set internalValue(value: ElastictranscoderPipelineThumbnailConfig | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    resetBucket(): void;
    get bucketInput(): string | undefined;
    private _storageClass?;
    get storageClass(): string;
    set storageClass(value: string);
    resetStorageClass(): void;
    get storageClassInput(): string | undefined;
}
export interface ElastictranscoderPipelineThumbnailConfigPermissions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#access ElastictranscoderPipeline#access}
    */
    readonly access?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#grantee ElastictranscoderPipeline#grantee}
    */
    readonly grantee?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline#grantee_type ElastictranscoderPipeline#grantee_type}
    */
    readonly granteeType?: string;
}
export declare function elastictranscoderPipelineThumbnailConfigPermissionsToTerraform(struct?: ElastictranscoderPipelineThumbnailConfigPermissions | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline aws_elastictranscoder_pipeline}
*/
export declare class ElastictranscoderPipeline extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_elastictranscoder_pipeline";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_pipeline aws_elastictranscoder_pipeline} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ElastictranscoderPipelineConfig
    */
    constructor(scope: Construct, id: string, config: ElastictranscoderPipelineConfig);
    get arn(): string;
    private _awsKmsKeyArn?;
    get awsKmsKeyArn(): string;
    set awsKmsKeyArn(value: string);
    resetAwsKmsKeyArn(): void;
    get awsKmsKeyArnInput(): string | undefined;
    get id(): string;
    private _inputBucket?;
    get inputBucket(): string;
    set inputBucket(value: string);
    get inputBucketInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _outputBucket?;
    get outputBucket(): string;
    set outputBucket(value: string);
    resetOutputBucket(): void;
    get outputBucketInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _contentConfig;
    get contentConfig(): ElastictranscoderPipelineContentConfigOutputReference;
    putContentConfig(value: ElastictranscoderPipelineContentConfig): void;
    resetContentConfig(): void;
    get contentConfigInput(): ElastictranscoderPipelineContentConfig | undefined;
    private _contentConfigPermissions?;
    get contentConfigPermissions(): ElastictranscoderPipelineContentConfigPermissions[] | cdktf.IResolvable;
    set contentConfigPermissions(value: ElastictranscoderPipelineContentConfigPermissions[] | cdktf.IResolvable);
    resetContentConfigPermissions(): void;
    get contentConfigPermissionsInput(): cdktf.IResolvable | ElastictranscoderPipelineContentConfigPermissions[] | undefined;
    private _notifications;
    get notifications(): ElastictranscoderPipelineNotificationsOutputReference;
    putNotifications(value: ElastictranscoderPipelineNotifications): void;
    resetNotifications(): void;
    get notificationsInput(): ElastictranscoderPipelineNotifications | undefined;
    private _thumbnailConfig;
    get thumbnailConfig(): ElastictranscoderPipelineThumbnailConfigOutputReference;
    putThumbnailConfig(value: ElastictranscoderPipelineThumbnailConfig): void;
    resetThumbnailConfig(): void;
    get thumbnailConfigInput(): ElastictranscoderPipelineThumbnailConfig | undefined;
    private _thumbnailConfigPermissions?;
    get thumbnailConfigPermissions(): ElastictranscoderPipelineThumbnailConfigPermissions[] | cdktf.IResolvable;
    set thumbnailConfigPermissions(value: ElastictranscoderPipelineThumbnailConfigPermissions[] | cdktf.IResolvable);
    resetThumbnailConfigPermissions(): void;
    get thumbnailConfigPermissionsInput(): cdktf.IResolvable | ElastictranscoderPipelineThumbnailConfigPermissions[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=elastictranscoder-pipeline.d.ts.map