"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElastictranscoderPreset = exports.elastictranscoderPresetVideoWatermarksToTerraform = exports.ElastictranscoderPresetVideoOutputReference = exports.elastictranscoderPresetVideoToTerraform = exports.ElastictranscoderPresetThumbnailsOutputReference = exports.elastictranscoderPresetThumbnailsToTerraform = exports.ElastictranscoderPresetAudioCodecOptionsOutputReference = exports.elastictranscoderPresetAudioCodecOptionsToTerraform = exports.ElastictranscoderPresetAudioOutputReference = exports.elastictranscoderPresetAudioToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function elastictranscoderPresetAudioToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        audio_packing_mode: cdktf.stringToTerraform(struct.audioPackingMode),
        bit_rate: cdktf.stringToTerraform(struct.bitRate),
        channels: cdktf.stringToTerraform(struct.channels),
        codec: cdktf.stringToTerraform(struct.codec),
        sample_rate: cdktf.stringToTerraform(struct.sampleRate),
    };
}
exports.elastictranscoderPresetAudioToTerraform = elastictranscoderPresetAudioToTerraform;
class ElastictranscoderPresetAudioOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._audioPackingMode !== undefined) {
            hasAnyValues = true;
            internalValueResult.audioPackingMode = this._audioPackingMode;
        }
        if (this._bitRate !== undefined) {
            hasAnyValues = true;
            internalValueResult.bitRate = this._bitRate;
        }
        if (this._channels !== undefined) {
            hasAnyValues = true;
            internalValueResult.channels = this._channels;
        }
        if (this._codec !== undefined) {
            hasAnyValues = true;
            internalValueResult.codec = this._codec;
        }
        if (this._sampleRate !== undefined) {
            hasAnyValues = true;
            internalValueResult.sampleRate = this._sampleRate;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._audioPackingMode = undefined;
            this._bitRate = undefined;
            this._channels = undefined;
            this._codec = undefined;
            this._sampleRate = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._audioPackingMode = value.audioPackingMode;
            this._bitRate = value.bitRate;
            this._channels = value.channels;
            this._codec = value.codec;
            this._sampleRate = value.sampleRate;
        }
    }
    get audioPackingMode() {
        return this.getStringAttribute('audio_packing_mode');
    }
    set audioPackingMode(value) {
        this._audioPackingMode = value;
    }
    resetAudioPackingMode() {
        this._audioPackingMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get audioPackingModeInput() {
        return this._audioPackingMode;
    }
    get bitRate() {
        return this.getStringAttribute('bit_rate');
    }
    set bitRate(value) {
        this._bitRate = value;
    }
    resetBitRate() {
        this._bitRate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bitRateInput() {
        return this._bitRate;
    }
    get channels() {
        return this.getStringAttribute('channels');
    }
    set channels(value) {
        this._channels = value;
    }
    resetChannels() {
        this._channels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get channelsInput() {
        return this._channels;
    }
    get codec() {
        return this.getStringAttribute('codec');
    }
    set codec(value) {
        this._codec = value;
    }
    resetCodec() {
        this._codec = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get codecInput() {
        return this._codec;
    }
    get sampleRate() {
        return this.getStringAttribute('sample_rate');
    }
    set sampleRate(value) {
        this._sampleRate = value;
    }
    resetSampleRate() {
        this._sampleRate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sampleRateInput() {
        return this._sampleRate;
    }
}
exports.ElastictranscoderPresetAudioOutputReference = ElastictranscoderPresetAudioOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ElastictranscoderPresetAudioOutputReference[_a] = { fqn: "@cdktf/provider-aws.elastictranscoder.ElastictranscoderPresetAudioOutputReference", version: "7.0.64" };
function elastictranscoderPresetAudioCodecOptionsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        bit_depth: cdktf.stringToTerraform(struct.bitDepth),
        bit_order: cdktf.stringToTerraform(struct.bitOrder),
        profile: cdktf.stringToTerraform(struct.profile),
        signed: cdktf.stringToTerraform(struct.signed),
    };
}
exports.elastictranscoderPresetAudioCodecOptionsToTerraform = elastictranscoderPresetAudioCodecOptionsToTerraform;
class ElastictranscoderPresetAudioCodecOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._bitDepth !== undefined) {
            hasAnyValues = true;
            internalValueResult.bitDepth = this._bitDepth;
        }
        if (this._bitOrder !== undefined) {
            hasAnyValues = true;
            internalValueResult.bitOrder = this._bitOrder;
        }
        if (this._profile !== undefined) {
            hasAnyValues = true;
            internalValueResult.profile = this._profile;
        }
        if (this._signed !== undefined) {
            hasAnyValues = true;
            internalValueResult.signed = this._signed;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._bitDepth = undefined;
            this._bitOrder = undefined;
            this._profile = undefined;
            this._signed = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._bitDepth = value.bitDepth;
            this._bitOrder = value.bitOrder;
            this._profile = value.profile;
            this._signed = value.signed;
        }
    }
    get bitDepth() {
        return this.getStringAttribute('bit_depth');
    }
    set bitDepth(value) {
        this._bitDepth = value;
    }
    resetBitDepth() {
        this._bitDepth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bitDepthInput() {
        return this._bitDepth;
    }
    get bitOrder() {
        return this.getStringAttribute('bit_order');
    }
    set bitOrder(value) {
        this._bitOrder = value;
    }
    resetBitOrder() {
        this._bitOrder = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bitOrderInput() {
        return this._bitOrder;
    }
    get profile() {
        return this.getStringAttribute('profile');
    }
    set profile(value) {
        this._profile = value;
    }
    resetProfile() {
        this._profile = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get profileInput() {
        return this._profile;
    }
    get signed() {
        return this.getStringAttribute('signed');
    }
    set signed(value) {
        this._signed = value;
    }
    resetSigned() {
        this._signed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get signedInput() {
        return this._signed;
    }
}
exports.ElastictranscoderPresetAudioCodecOptionsOutputReference = ElastictranscoderPresetAudioCodecOptionsOutputReference;
_b = JSII_RTTI_SYMBOL_1;
ElastictranscoderPresetAudioCodecOptionsOutputReference[_b] = { fqn: "@cdktf/provider-aws.elastictranscoder.ElastictranscoderPresetAudioCodecOptionsOutputReference", version: "7.0.64" };
function elastictranscoderPresetThumbnailsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        aspect_ratio: cdktf.stringToTerraform(struct.aspectRatio),
        format: cdktf.stringToTerraform(struct.format),
        interval: cdktf.stringToTerraform(struct.interval),
        max_height: cdktf.stringToTerraform(struct.maxHeight),
        max_width: cdktf.stringToTerraform(struct.maxWidth),
        padding_policy: cdktf.stringToTerraform(struct.paddingPolicy),
        resolution: cdktf.stringToTerraform(struct.resolution),
        sizing_policy: cdktf.stringToTerraform(struct.sizingPolicy),
    };
}
exports.elastictranscoderPresetThumbnailsToTerraform = elastictranscoderPresetThumbnailsToTerraform;
class ElastictranscoderPresetThumbnailsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._aspectRatio !== undefined) {
            hasAnyValues = true;
            internalValueResult.aspectRatio = this._aspectRatio;
        }
        if (this._format !== undefined) {
            hasAnyValues = true;
            internalValueResult.format = this._format;
        }
        if (this._interval !== undefined) {
            hasAnyValues = true;
            internalValueResult.interval = this._interval;
        }
        if (this._maxHeight !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxHeight = this._maxHeight;
        }
        if (this._maxWidth !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxWidth = this._maxWidth;
        }
        if (this._paddingPolicy !== undefined) {
            hasAnyValues = true;
            internalValueResult.paddingPolicy = this._paddingPolicy;
        }
        if (this._resolution !== undefined) {
            hasAnyValues = true;
            internalValueResult.resolution = this._resolution;
        }
        if (this._sizingPolicy !== undefined) {
            hasAnyValues = true;
            internalValueResult.sizingPolicy = this._sizingPolicy;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._aspectRatio = undefined;
            this._format = undefined;
            this._interval = undefined;
            this._maxHeight = undefined;
            this._maxWidth = undefined;
            this._paddingPolicy = undefined;
            this._resolution = undefined;
            this._sizingPolicy = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._aspectRatio = value.aspectRatio;
            this._format = value.format;
            this._interval = value.interval;
            this._maxHeight = value.maxHeight;
            this._maxWidth = value.maxWidth;
            this._paddingPolicy = value.paddingPolicy;
            this._resolution = value.resolution;
            this._sizingPolicy = value.sizingPolicy;
        }
    }
    get aspectRatio() {
        return this.getStringAttribute('aspect_ratio');
    }
    set aspectRatio(value) {
        this._aspectRatio = value;
    }
    resetAspectRatio() {
        this._aspectRatio = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aspectRatioInput() {
        return this._aspectRatio;
    }
    get format() {
        return this.getStringAttribute('format');
    }
    set format(value) {
        this._format = value;
    }
    resetFormat() {
        this._format = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get formatInput() {
        return this._format;
    }
    get interval() {
        return this.getStringAttribute('interval');
    }
    set interval(value) {
        this._interval = value;
    }
    resetInterval() {
        this._interval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get intervalInput() {
        return this._interval;
    }
    get maxHeight() {
        return this.getStringAttribute('max_height');
    }
    set maxHeight(value) {
        this._maxHeight = value;
    }
    resetMaxHeight() {
        this._maxHeight = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxHeightInput() {
        return this._maxHeight;
    }
    get maxWidth() {
        return this.getStringAttribute('max_width');
    }
    set maxWidth(value) {
        this._maxWidth = value;
    }
    resetMaxWidth() {
        this._maxWidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxWidthInput() {
        return this._maxWidth;
    }
    get paddingPolicy() {
        return this.getStringAttribute('padding_policy');
    }
    set paddingPolicy(value) {
        this._paddingPolicy = value;
    }
    resetPaddingPolicy() {
        this._paddingPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get paddingPolicyInput() {
        return this._paddingPolicy;
    }
    get resolution() {
        return this.getStringAttribute('resolution');
    }
    set resolution(value) {
        this._resolution = value;
    }
    resetResolution() {
        this._resolution = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resolutionInput() {
        return this._resolution;
    }
    get sizingPolicy() {
        return this.getStringAttribute('sizing_policy');
    }
    set sizingPolicy(value) {
        this._sizingPolicy = value;
    }
    resetSizingPolicy() {
        this._sizingPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sizingPolicyInput() {
        return this._sizingPolicy;
    }
}
exports.ElastictranscoderPresetThumbnailsOutputReference = ElastictranscoderPresetThumbnailsOutputReference;
_c = JSII_RTTI_SYMBOL_1;
ElastictranscoderPresetThumbnailsOutputReference[_c] = { fqn: "@cdktf/provider-aws.elastictranscoder.ElastictranscoderPresetThumbnailsOutputReference", version: "7.0.64" };
function elastictranscoderPresetVideoToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        aspect_ratio: cdktf.stringToTerraform(struct.aspectRatio),
        bit_rate: cdktf.stringToTerraform(struct.bitRate),
        codec: cdktf.stringToTerraform(struct.codec),
        display_aspect_ratio: cdktf.stringToTerraform(struct.displayAspectRatio),
        fixed_gop: cdktf.stringToTerraform(struct.fixedGop),
        frame_rate: cdktf.stringToTerraform(struct.frameRate),
        keyframes_max_dist: cdktf.stringToTerraform(struct.keyframesMaxDist),
        max_frame_rate: cdktf.stringToTerraform(struct.maxFrameRate),
        max_height: cdktf.stringToTerraform(struct.maxHeight),
        max_width: cdktf.stringToTerraform(struct.maxWidth),
        padding_policy: cdktf.stringToTerraform(struct.paddingPolicy),
        resolution: cdktf.stringToTerraform(struct.resolution),
        sizing_policy: cdktf.stringToTerraform(struct.sizingPolicy),
    };
}
exports.elastictranscoderPresetVideoToTerraform = elastictranscoderPresetVideoToTerraform;
class ElastictranscoderPresetVideoOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._aspectRatio !== undefined) {
            hasAnyValues = true;
            internalValueResult.aspectRatio = this._aspectRatio;
        }
        if (this._bitRate !== undefined) {
            hasAnyValues = true;
            internalValueResult.bitRate = this._bitRate;
        }
        if (this._codec !== undefined) {
            hasAnyValues = true;
            internalValueResult.codec = this._codec;
        }
        if (this._displayAspectRatio !== undefined) {
            hasAnyValues = true;
            internalValueResult.displayAspectRatio = this._displayAspectRatio;
        }
        if (this._fixedGop !== undefined) {
            hasAnyValues = true;
            internalValueResult.fixedGop = this._fixedGop;
        }
        if (this._frameRate !== undefined) {
            hasAnyValues = true;
            internalValueResult.frameRate = this._frameRate;
        }
        if (this._keyframesMaxDist !== undefined) {
            hasAnyValues = true;
            internalValueResult.keyframesMaxDist = this._keyframesMaxDist;
        }
        if (this._maxFrameRate !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxFrameRate = this._maxFrameRate;
        }
        if (this._maxHeight !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxHeight = this._maxHeight;
        }
        if (this._maxWidth !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxWidth = this._maxWidth;
        }
        if (this._paddingPolicy !== undefined) {
            hasAnyValues = true;
            internalValueResult.paddingPolicy = this._paddingPolicy;
        }
        if (this._resolution !== undefined) {
            hasAnyValues = true;
            internalValueResult.resolution = this._resolution;
        }
        if (this._sizingPolicy !== undefined) {
            hasAnyValues = true;
            internalValueResult.sizingPolicy = this._sizingPolicy;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._aspectRatio = undefined;
            this._bitRate = undefined;
            this._codec = undefined;
            this._displayAspectRatio = undefined;
            this._fixedGop = undefined;
            this._frameRate = undefined;
            this._keyframesMaxDist = undefined;
            this._maxFrameRate = undefined;
            this._maxHeight = undefined;
            this._maxWidth = undefined;
            this._paddingPolicy = undefined;
            this._resolution = undefined;
            this._sizingPolicy = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._aspectRatio = value.aspectRatio;
            this._bitRate = value.bitRate;
            this._codec = value.codec;
            this._displayAspectRatio = value.displayAspectRatio;
            this._fixedGop = value.fixedGop;
            this._frameRate = value.frameRate;
            this._keyframesMaxDist = value.keyframesMaxDist;
            this._maxFrameRate = value.maxFrameRate;
            this._maxHeight = value.maxHeight;
            this._maxWidth = value.maxWidth;
            this._paddingPolicy = value.paddingPolicy;
            this._resolution = value.resolution;
            this._sizingPolicy = value.sizingPolicy;
        }
    }
    get aspectRatio() {
        return this.getStringAttribute('aspect_ratio');
    }
    set aspectRatio(value) {
        this._aspectRatio = value;
    }
    resetAspectRatio() {
        this._aspectRatio = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aspectRatioInput() {
        return this._aspectRatio;
    }
    get bitRate() {
        return this.getStringAttribute('bit_rate');
    }
    set bitRate(value) {
        this._bitRate = value;
    }
    resetBitRate() {
        this._bitRate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bitRateInput() {
        return this._bitRate;
    }
    get codec() {
        return this.getStringAttribute('codec');
    }
    set codec(value) {
        this._codec = value;
    }
    resetCodec() {
        this._codec = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get codecInput() {
        return this._codec;
    }
    get displayAspectRatio() {
        return this.getStringAttribute('display_aspect_ratio');
    }
    set displayAspectRatio(value) {
        this._displayAspectRatio = value;
    }
    resetDisplayAspectRatio() {
        this._displayAspectRatio = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get displayAspectRatioInput() {
        return this._displayAspectRatio;
    }
    get fixedGop() {
        return this.getStringAttribute('fixed_gop');
    }
    set fixedGop(value) {
        this._fixedGop = value;
    }
    resetFixedGop() {
        this._fixedGop = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fixedGopInput() {
        return this._fixedGop;
    }
    get frameRate() {
        return this.getStringAttribute('frame_rate');
    }
    set frameRate(value) {
        this._frameRate = value;
    }
    resetFrameRate() {
        this._frameRate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get frameRateInput() {
        return this._frameRate;
    }
    get keyframesMaxDist() {
        return this.getStringAttribute('keyframes_max_dist');
    }
    set keyframesMaxDist(value) {
        this._keyframesMaxDist = value;
    }
    resetKeyframesMaxDist() {
        this._keyframesMaxDist = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keyframesMaxDistInput() {
        return this._keyframesMaxDist;
    }
    get maxFrameRate() {
        return this.getStringAttribute('max_frame_rate');
    }
    set maxFrameRate(value) {
        this._maxFrameRate = value;
    }
    resetMaxFrameRate() {
        this._maxFrameRate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxFrameRateInput() {
        return this._maxFrameRate;
    }
    get maxHeight() {
        return this.getStringAttribute('max_height');
    }
    set maxHeight(value) {
        this._maxHeight = value;
    }
    resetMaxHeight() {
        this._maxHeight = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxHeightInput() {
        return this._maxHeight;
    }
    get maxWidth() {
        return this.getStringAttribute('max_width');
    }
    set maxWidth(value) {
        this._maxWidth = value;
    }
    resetMaxWidth() {
        this._maxWidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxWidthInput() {
        return this._maxWidth;
    }
    get paddingPolicy() {
        return this.getStringAttribute('padding_policy');
    }
    set paddingPolicy(value) {
        this._paddingPolicy = value;
    }
    resetPaddingPolicy() {
        this._paddingPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get paddingPolicyInput() {
        return this._paddingPolicy;
    }
    get resolution() {
        return this.getStringAttribute('resolution');
    }
    set resolution(value) {
        this._resolution = value;
    }
    resetResolution() {
        this._resolution = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resolutionInput() {
        return this._resolution;
    }
    get sizingPolicy() {
        return this.getStringAttribute('sizing_policy');
    }
    set sizingPolicy(value) {
        this._sizingPolicy = value;
    }
    resetSizingPolicy() {
        this._sizingPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sizingPolicyInput() {
        return this._sizingPolicy;
    }
}
exports.ElastictranscoderPresetVideoOutputReference = ElastictranscoderPresetVideoOutputReference;
_d = JSII_RTTI_SYMBOL_1;
ElastictranscoderPresetVideoOutputReference[_d] = { fqn: "@cdktf/provider-aws.elastictranscoder.ElastictranscoderPresetVideoOutputReference", version: "7.0.64" };
function elastictranscoderPresetVideoWatermarksToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        horizontal_align: cdktf.stringToTerraform(struct.horizontalAlign),
        horizontal_offset: cdktf.stringToTerraform(struct.horizontalOffset),
        id: cdktf.stringToTerraform(struct.id),
        max_height: cdktf.stringToTerraform(struct.maxHeight),
        max_width: cdktf.stringToTerraform(struct.maxWidth),
        opacity: cdktf.stringToTerraform(struct.opacity),
        sizing_policy: cdktf.stringToTerraform(struct.sizingPolicy),
        target: cdktf.stringToTerraform(struct.target),
        vertical_align: cdktf.stringToTerraform(struct.verticalAlign),
        vertical_offset: cdktf.stringToTerraform(struct.verticalOffset),
    };
}
exports.elastictranscoderPresetVideoWatermarksToTerraform = elastictranscoderPresetVideoWatermarksToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_preset aws_elastictranscoder_preset}
*/
class ElastictranscoderPreset extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/elastictranscoder_preset aws_elastictranscoder_preset} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ElastictranscoderPresetConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_elastictranscoder_preset',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // audio - computed: false, optional: true, required: false
        this._audio = new ElastictranscoderPresetAudioOutputReference(this, "audio");
        // audio_codec_options - computed: false, optional: true, required: false
        this._audioCodecOptions = new ElastictranscoderPresetAudioCodecOptionsOutputReference(this, "audio_codec_options");
        // thumbnails - computed: false, optional: true, required: false
        this._thumbnails = new ElastictranscoderPresetThumbnailsOutputReference(this, "thumbnails");
        // video - computed: false, optional: true, required: false
        this._video = new ElastictranscoderPresetVideoOutputReference(this, "video");
        this._container = config.container;
        this._description = config.description;
        this._name = config.name;
        this._type = config.type;
        this._videoCodecOptions = config.videoCodecOptions;
        this._audio.internalValue = config.audio;
        this._audioCodecOptions.internalValue = config.audioCodecOptions;
        this._thumbnails.internalValue = config.thumbnails;
        this._video.internalValue = config.video;
        this._videoWatermarks = config.videoWatermarks;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: false
    get arn() {
        return this.getStringAttribute('arn');
    }
    get container() {
        return this.getStringAttribute('container');
    }
    set container(value) {
        this._container = value;
    }
    // Temporarily expose input value. Use with caution.
    get containerInput() {
        return this._container;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    resetName() {
        this._name = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    resetType() {
        this._type = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
    get videoCodecOptions() {
        return this.getStringMapAttribute('video_codec_options');
    }
    set videoCodecOptions(value) {
        this._videoCodecOptions = value;
    }
    resetVideoCodecOptions() {
        this._videoCodecOptions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get videoCodecOptionsInput() {
        return this._videoCodecOptions;
    }
    get audio() {
        return this._audio;
    }
    putAudio(value) {
        this._audio.internalValue = value;
    }
    resetAudio() {
        this._audio.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get audioInput() {
        return this._audio.internalValue;
    }
    get audioCodecOptions() {
        return this._audioCodecOptions;
    }
    putAudioCodecOptions(value) {
        this._audioCodecOptions.internalValue = value;
    }
    resetAudioCodecOptions() {
        this._audioCodecOptions.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get audioCodecOptionsInput() {
        return this._audioCodecOptions.internalValue;
    }
    get thumbnails() {
        return this._thumbnails;
    }
    putThumbnails(value) {
        this._thumbnails.internalValue = value;
    }
    resetThumbnails() {
        this._thumbnails.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get thumbnailsInput() {
        return this._thumbnails.internalValue;
    }
    get video() {
        return this._video;
    }
    putVideo(value) {
        this._video.internalValue = value;
    }
    resetVideo() {
        this._video.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get videoInput() {
        return this._video.internalValue;
    }
    get videoWatermarks() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('video_watermarks')));
    }
    set videoWatermarks(value) {
        this._videoWatermarks = value;
    }
    resetVideoWatermarks() {
        this._videoWatermarks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get videoWatermarksInput() {
        return this._videoWatermarks;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            container: cdktf.stringToTerraform(this._container),
            description: cdktf.stringToTerraform(this._description),
            name: cdktf.stringToTerraform(this._name),
            type: cdktf.stringToTerraform(this._type),
            video_codec_options: cdktf.hashMapper(cdktf.stringToTerraform)(this._videoCodecOptions),
            audio: elastictranscoderPresetAudioToTerraform(this._audio.internalValue),
            audio_codec_options: elastictranscoderPresetAudioCodecOptionsToTerraform(this._audioCodecOptions.internalValue),
            thumbnails: elastictranscoderPresetThumbnailsToTerraform(this._thumbnails.internalValue),
            video: elastictranscoderPresetVideoToTerraform(this._video.internalValue),
            video_watermarks: cdktf.listMapper(elastictranscoderPresetVideoWatermarksToTerraform)(this._videoWatermarks),
        };
    }
}
exports.ElastictranscoderPreset = ElastictranscoderPreset;
_e = JSII_RTTI_SYMBOL_1;
ElastictranscoderPreset[_e] = { fqn: "@cdktf/provider-aws.elastictranscoder.ElastictranscoderPreset", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
ElastictranscoderPreset.tfResourceType = "aws_elastictranscoder_preset";
//# sourceMappingURL=data:application/json;base64,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