import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Elastic Load Balancer
*/
export interface DataAwsAlbListenerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/alb_listener#arn DataAwsAlbListener#arn}
    */
    readonly arn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/alb_listener#load_balancer_arn DataAwsAlbListener#load_balancer_arn}
    */
    readonly loadBalancerArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/alb_listener#port DataAwsAlbListener#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/alb_listener#tags DataAwsAlbListener#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataAwsAlbListenerDefaultActionAuthenticateCognito {
}
export declare function dataAwsAlbListenerDefaultActionAuthenticateCognitoToTerraform(struct?: DataAwsAlbListenerDefaultActionAuthenticateCognito): any;
export declare class DataAwsAlbListenerDefaultActionAuthenticateCognitoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsAlbListenerDefaultActionAuthenticateCognito | undefined;
    set internalValue(value: DataAwsAlbListenerDefaultActionAuthenticateCognito | undefined);
    authenticationRequestExtraParams(key: string): string | cdktf.IResolvable;
    get onUnauthenticatedRequest(): string;
    get scope(): string;
    get sessionCookieName(): string;
    get sessionTimeout(): number;
    get userPoolArn(): string;
    get userPoolClientId(): string;
    get userPoolDomain(): string;
}
export declare class DataAwsAlbListenerDefaultActionAuthenticateCognitoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsAlbListenerDefaultActionAuthenticateCognitoOutputReference;
}
export interface DataAwsAlbListenerDefaultActionAuthenticateOidc {
}
export declare function dataAwsAlbListenerDefaultActionAuthenticateOidcToTerraform(struct?: DataAwsAlbListenerDefaultActionAuthenticateOidc): any;
export declare class DataAwsAlbListenerDefaultActionAuthenticateOidcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsAlbListenerDefaultActionAuthenticateOidc | undefined;
    set internalValue(value: DataAwsAlbListenerDefaultActionAuthenticateOidc | undefined);
    authenticationRequestExtraParams(key: string): string | cdktf.IResolvable;
    get authorizationEndpoint(): string;
    get clientId(): string;
    get clientSecret(): string;
    get issuer(): string;
    get onUnauthenticatedRequest(): string;
    get scope(): string;
    get sessionCookieName(): string;
    get sessionTimeout(): number;
    get tokenEndpoint(): string;
    get userInfoEndpoint(): string;
}
export declare class DataAwsAlbListenerDefaultActionAuthenticateOidcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsAlbListenerDefaultActionAuthenticateOidcOutputReference;
}
export interface DataAwsAlbListenerDefaultActionFixedResponse {
}
export declare function dataAwsAlbListenerDefaultActionFixedResponseToTerraform(struct?: DataAwsAlbListenerDefaultActionFixedResponse): any;
export declare class DataAwsAlbListenerDefaultActionFixedResponseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsAlbListenerDefaultActionFixedResponse | undefined;
    set internalValue(value: DataAwsAlbListenerDefaultActionFixedResponse | undefined);
    get contentType(): string;
    get messageBody(): string;
    get statusCode(): string;
}
export declare class DataAwsAlbListenerDefaultActionFixedResponseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsAlbListenerDefaultActionFixedResponseOutputReference;
}
export interface DataAwsAlbListenerDefaultActionForwardStickiness {
}
export declare function dataAwsAlbListenerDefaultActionForwardStickinessToTerraform(struct?: DataAwsAlbListenerDefaultActionForwardStickiness): any;
export declare class DataAwsAlbListenerDefaultActionForwardStickinessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsAlbListenerDefaultActionForwardStickiness | undefined;
    set internalValue(value: DataAwsAlbListenerDefaultActionForwardStickiness | undefined);
    get duration(): number;
    get enabled(): cdktf.IResolvable;
}
export declare class DataAwsAlbListenerDefaultActionForwardStickinessList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsAlbListenerDefaultActionForwardStickinessOutputReference;
}
export interface DataAwsAlbListenerDefaultActionForwardTargetGroup {
}
export declare function dataAwsAlbListenerDefaultActionForwardTargetGroupToTerraform(struct?: DataAwsAlbListenerDefaultActionForwardTargetGroup): any;
export declare class DataAwsAlbListenerDefaultActionForwardTargetGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsAlbListenerDefaultActionForwardTargetGroup | undefined;
    set internalValue(value: DataAwsAlbListenerDefaultActionForwardTargetGroup | undefined);
    get arn(): string;
    get weight(): number;
}
export declare class DataAwsAlbListenerDefaultActionForwardTargetGroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsAlbListenerDefaultActionForwardTargetGroupOutputReference;
}
export interface DataAwsAlbListenerDefaultActionForward {
}
export declare function dataAwsAlbListenerDefaultActionForwardToTerraform(struct?: DataAwsAlbListenerDefaultActionForward): any;
export declare class DataAwsAlbListenerDefaultActionForwardOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsAlbListenerDefaultActionForward | undefined;
    set internalValue(value: DataAwsAlbListenerDefaultActionForward | undefined);
    private _stickiness;
    get stickiness(): DataAwsAlbListenerDefaultActionForwardStickinessList;
    private _targetGroup;
    get targetGroup(): DataAwsAlbListenerDefaultActionForwardTargetGroupList;
}
export declare class DataAwsAlbListenerDefaultActionForwardList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsAlbListenerDefaultActionForwardOutputReference;
}
export interface DataAwsAlbListenerDefaultActionRedirect {
}
export declare function dataAwsAlbListenerDefaultActionRedirectToTerraform(struct?: DataAwsAlbListenerDefaultActionRedirect): any;
export declare class DataAwsAlbListenerDefaultActionRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsAlbListenerDefaultActionRedirect | undefined;
    set internalValue(value: DataAwsAlbListenerDefaultActionRedirect | undefined);
    get host(): string;
    get path(): string;
    get port(): string;
    get protocol(): string;
    get query(): string;
    get statusCode(): string;
}
export declare class DataAwsAlbListenerDefaultActionRedirectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsAlbListenerDefaultActionRedirectOutputReference;
}
export interface DataAwsAlbListenerDefaultAction {
}
export declare function dataAwsAlbListenerDefaultActionToTerraform(struct?: DataAwsAlbListenerDefaultAction): any;
export declare class DataAwsAlbListenerDefaultActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsAlbListenerDefaultAction | undefined;
    set internalValue(value: DataAwsAlbListenerDefaultAction | undefined);
    private _authenticateCognito;
    get authenticateCognito(): DataAwsAlbListenerDefaultActionAuthenticateCognitoList;
    private _authenticateOidc;
    get authenticateOidc(): DataAwsAlbListenerDefaultActionAuthenticateOidcList;
    private _fixedResponse;
    get fixedResponse(): DataAwsAlbListenerDefaultActionFixedResponseList;
    private _forward;
    get forward(): DataAwsAlbListenerDefaultActionForwardList;
    get order(): number;
    private _redirect;
    get redirect(): DataAwsAlbListenerDefaultActionRedirectList;
    get targetGroupArn(): string;
    get type(): string;
}
export declare class DataAwsAlbListenerDefaultActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsAlbListenerDefaultActionOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/alb_listener aws_alb_listener}
*/
export declare class DataAwsAlbListener extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_alb_listener";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/alb_listener aws_alb_listener} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsAlbListenerConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsAlbListenerConfig);
    get alpnPolicy(): string;
    private _arn?;
    get arn(): string;
    set arn(value: string);
    resetArn(): void;
    get arnInput(): string | undefined;
    get certificateArn(): string;
    private _defaultAction;
    get defaultAction(): DataAwsAlbListenerDefaultActionList;
    get id(): string;
    private _loadBalancerArn?;
    get loadBalancerArn(): string;
    set loadBalancerArn(value: string);
    resetLoadBalancerArn(): void;
    get loadBalancerArnInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    get protocol(): string;
    get sslPolicy(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-alb-listener.d.ts.map