import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Elastic MapReduce
*/
export interface DataAwsEmrcontainersVirtualClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/emrcontainers_virtual_cluster#tags DataAwsEmrcontainersVirtualCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/emrcontainers_virtual_cluster#virtual_cluster_id DataAwsEmrcontainersVirtualCluster#virtual_cluster_id}
    */
    readonly virtualClusterId: string;
}
export interface DataAwsEmrcontainersVirtualClusterContainerProviderInfoEksInfo {
}
export declare function dataAwsEmrcontainersVirtualClusterContainerProviderInfoEksInfoToTerraform(struct?: DataAwsEmrcontainersVirtualClusterContainerProviderInfoEksInfo): any;
export declare class DataAwsEmrcontainersVirtualClusterContainerProviderInfoEksInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsEmrcontainersVirtualClusterContainerProviderInfoEksInfo | undefined;
    set internalValue(value: DataAwsEmrcontainersVirtualClusterContainerProviderInfoEksInfo | undefined);
    get namespace(): string;
}
export declare class DataAwsEmrcontainersVirtualClusterContainerProviderInfoEksInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsEmrcontainersVirtualClusterContainerProviderInfoEksInfoOutputReference;
}
export interface DataAwsEmrcontainersVirtualClusterContainerProviderInfo {
}
export declare function dataAwsEmrcontainersVirtualClusterContainerProviderInfoToTerraform(struct?: DataAwsEmrcontainersVirtualClusterContainerProviderInfo): any;
export declare class DataAwsEmrcontainersVirtualClusterContainerProviderInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsEmrcontainersVirtualClusterContainerProviderInfo | undefined;
    set internalValue(value: DataAwsEmrcontainersVirtualClusterContainerProviderInfo | undefined);
    private _eksInfo;
    get eksInfo(): DataAwsEmrcontainersVirtualClusterContainerProviderInfoEksInfoList;
}
export declare class DataAwsEmrcontainersVirtualClusterContainerProviderInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsEmrcontainersVirtualClusterContainerProviderInfoOutputReference;
}
export interface DataAwsEmrcontainersVirtualClusterContainerProvider {
}
export declare function dataAwsEmrcontainersVirtualClusterContainerProviderToTerraform(struct?: DataAwsEmrcontainersVirtualClusterContainerProvider): any;
export declare class DataAwsEmrcontainersVirtualClusterContainerProviderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsEmrcontainersVirtualClusterContainerProvider | undefined;
    set internalValue(value: DataAwsEmrcontainersVirtualClusterContainerProvider | undefined);
    get id(): string;
    private _info;
    get info(): DataAwsEmrcontainersVirtualClusterContainerProviderInfoList;
    get type(): string;
}
export declare class DataAwsEmrcontainersVirtualClusterContainerProviderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsEmrcontainersVirtualClusterContainerProviderOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/emrcontainers_virtual_cluster aws_emrcontainers_virtual_cluster}
*/
export declare class DataAwsEmrcontainersVirtualCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_emrcontainers_virtual_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/emrcontainers_virtual_cluster aws_emrcontainers_virtual_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsEmrcontainersVirtualClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsEmrcontainersVirtualClusterConfig);
    get arn(): string;
    private _containerProvider;
    get containerProvider(): DataAwsEmrcontainersVirtualClusterContainerProviderList;
    get createdAt(): string;
    get id(): string;
    get name(): string;
    get state(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualClusterId?;
    get virtualClusterId(): string;
    set virtualClusterId(value: string);
    get virtualClusterIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-emrcontainers-virtual-cluster.d.ts.map