import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Elastic MapReduce
*/
export interface EmrcontainersVirtualClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/emrcontainers_virtual_cluster#name EmrcontainersVirtualCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/emrcontainers_virtual_cluster#tags EmrcontainersVirtualCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/emrcontainers_virtual_cluster#tags_all EmrcontainersVirtualCluster#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * container_provider block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/emrcontainers_virtual_cluster#container_provider EmrcontainersVirtualCluster#container_provider}
    */
    readonly containerProvider: EmrcontainersVirtualClusterContainerProvider;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/emrcontainers_virtual_cluster#timeouts EmrcontainersVirtualCluster#timeouts}
    */
    readonly timeouts?: EmrcontainersVirtualClusterTimeouts;
}
export interface EmrcontainersVirtualClusterContainerProviderInfoEksInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/emrcontainers_virtual_cluster#namespace EmrcontainersVirtualCluster#namespace}
    */
    readonly namespace?: string;
}
export declare function emrcontainersVirtualClusterContainerProviderInfoEksInfoToTerraform(struct?: EmrcontainersVirtualClusterContainerProviderInfoEksInfoOutputReference | EmrcontainersVirtualClusterContainerProviderInfoEksInfo): any;
export declare class EmrcontainersVirtualClusterContainerProviderInfoEksInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EmrcontainersVirtualClusterContainerProviderInfoEksInfo | undefined;
    set internalValue(value: EmrcontainersVirtualClusterContainerProviderInfoEksInfo | undefined);
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface EmrcontainersVirtualClusterContainerProviderInfo {
    /**
    * eks_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/emrcontainers_virtual_cluster#eks_info EmrcontainersVirtualCluster#eks_info}
    */
    readonly eksInfo: EmrcontainersVirtualClusterContainerProviderInfoEksInfo;
}
export declare function emrcontainersVirtualClusterContainerProviderInfoToTerraform(struct?: EmrcontainersVirtualClusterContainerProviderInfoOutputReference | EmrcontainersVirtualClusterContainerProviderInfo): any;
export declare class EmrcontainersVirtualClusterContainerProviderInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EmrcontainersVirtualClusterContainerProviderInfo | undefined;
    set internalValue(value: EmrcontainersVirtualClusterContainerProviderInfo | undefined);
    private _eksInfo;
    get eksInfo(): EmrcontainersVirtualClusterContainerProviderInfoEksInfoOutputReference;
    putEksInfo(value: EmrcontainersVirtualClusterContainerProviderInfoEksInfo): void;
    get eksInfoInput(): EmrcontainersVirtualClusterContainerProviderInfoEksInfo | undefined;
}
export interface EmrcontainersVirtualClusterContainerProvider {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/emrcontainers_virtual_cluster#id EmrcontainersVirtualCluster#id}
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/emrcontainers_virtual_cluster#type EmrcontainersVirtualCluster#type}
    */
    readonly type: string;
    /**
    * info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/emrcontainers_virtual_cluster#info EmrcontainersVirtualCluster#info}
    */
    readonly info: EmrcontainersVirtualClusterContainerProviderInfo;
}
export declare function emrcontainersVirtualClusterContainerProviderToTerraform(struct?: EmrcontainersVirtualClusterContainerProviderOutputReference | EmrcontainersVirtualClusterContainerProvider): any;
export declare class EmrcontainersVirtualClusterContainerProviderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EmrcontainersVirtualClusterContainerProvider | undefined;
    set internalValue(value: EmrcontainersVirtualClusterContainerProvider | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _info;
    get info(): EmrcontainersVirtualClusterContainerProviderInfoOutputReference;
    putInfo(value: EmrcontainersVirtualClusterContainerProviderInfo): void;
    get infoInput(): EmrcontainersVirtualClusterContainerProviderInfo | undefined;
}
export interface EmrcontainersVirtualClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/emrcontainers_virtual_cluster#delete EmrcontainersVirtualCluster#delete}
    */
    readonly delete?: string;
}
export declare function emrcontainersVirtualClusterTimeoutsToTerraform(struct?: EmrcontainersVirtualClusterTimeoutsOutputReference | EmrcontainersVirtualClusterTimeouts | cdktf.IResolvable): any;
export declare class EmrcontainersVirtualClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EmrcontainersVirtualClusterTimeouts | undefined;
    set internalValue(value: EmrcontainersVirtualClusterTimeouts | undefined);
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/emrcontainers_virtual_cluster aws_emrcontainers_virtual_cluster}
*/
export declare class EmrcontainersVirtualCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_emrcontainers_virtual_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/emrcontainers_virtual_cluster aws_emrcontainers_virtual_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EmrcontainersVirtualClusterConfig
    */
    constructor(scope: Construct, id: string, config: EmrcontainersVirtualClusterConfig);
    get arn(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _containerProvider;
    get containerProvider(): EmrcontainersVirtualClusterContainerProviderOutputReference;
    putContainerProvider(value: EmrcontainersVirtualClusterContainerProvider): void;
    get containerProviderInput(): EmrcontainersVirtualClusterContainerProvider | undefined;
    private _timeouts;
    get timeouts(): EmrcontainersVirtualClusterTimeoutsOutputReference;
    putTimeouts(value: EmrcontainersVirtualClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): EmrcontainersVirtualClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=emrcontainers-virtual-cluster.d.ts.map