import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS CloudWatch Event Bridge
*/
export interface CloudwatchEventTargetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#arn CloudwatchEventTarget#arn}
    */
    readonly arn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#event_bus_name CloudwatchEventTarget#event_bus_name}
    */
    readonly eventBusName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#input CloudwatchEventTarget#input}
    */
    readonly input?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#input_path CloudwatchEventTarget#input_path}
    */
    readonly inputPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#role_arn CloudwatchEventTarget#role_arn}
    */
    readonly roleArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#rule CloudwatchEventTarget#rule}
    */
    readonly rule: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#target_id CloudwatchEventTarget#target_id}
    */
    readonly targetId?: string;
    /**
    * batch_target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#batch_target CloudwatchEventTarget#batch_target}
    */
    readonly batchTarget?: CloudwatchEventTargetBatchTarget;
    /**
    * dead_letter_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#dead_letter_config CloudwatchEventTarget#dead_letter_config}
    */
    readonly deadLetterConfig?: CloudwatchEventTargetDeadLetterConfig;
    /**
    * ecs_target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#ecs_target CloudwatchEventTarget#ecs_target}
    */
    readonly ecsTarget?: CloudwatchEventTargetEcsTarget;
    /**
    * http_target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#http_target CloudwatchEventTarget#http_target}
    */
    readonly httpTarget?: CloudwatchEventTargetHttpTarget;
    /**
    * input_transformer block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#input_transformer CloudwatchEventTarget#input_transformer}
    */
    readonly inputTransformer?: CloudwatchEventTargetInputTransformer;
    /**
    * kinesis_target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#kinesis_target CloudwatchEventTarget#kinesis_target}
    */
    readonly kinesisTarget?: CloudwatchEventTargetKinesisTarget;
    /**
    * redshift_target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#redshift_target CloudwatchEventTarget#redshift_target}
    */
    readonly redshiftTarget?: CloudwatchEventTargetRedshiftTarget;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#retry_policy CloudwatchEventTarget#retry_policy}
    */
    readonly retryPolicy?: CloudwatchEventTargetRetryPolicy;
    /**
    * run_command_targets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#run_command_targets CloudwatchEventTarget#run_command_targets}
    */
    readonly runCommandTargets?: CloudwatchEventTargetRunCommandTargets[] | cdktf.IResolvable;
    /**
    * sqs_target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#sqs_target CloudwatchEventTarget#sqs_target}
    */
    readonly sqsTarget?: CloudwatchEventTargetSqsTarget;
}
export interface CloudwatchEventTargetBatchTarget {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#array_size CloudwatchEventTarget#array_size}
    */
    readonly arraySize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#job_attempts CloudwatchEventTarget#job_attempts}
    */
    readonly jobAttempts?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#job_definition CloudwatchEventTarget#job_definition}
    */
    readonly jobDefinition: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#job_name CloudwatchEventTarget#job_name}
    */
    readonly jobName: string;
}
export declare function cloudwatchEventTargetBatchTargetToTerraform(struct?: CloudwatchEventTargetBatchTargetOutputReference | CloudwatchEventTargetBatchTarget): any;
export declare class CloudwatchEventTargetBatchTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudwatchEventTargetBatchTarget | undefined;
    set internalValue(value: CloudwatchEventTargetBatchTarget | undefined);
    private _arraySize?;
    get arraySize(): number;
    set arraySize(value: number);
    resetArraySize(): void;
    get arraySizeInput(): number | undefined;
    private _jobAttempts?;
    get jobAttempts(): number;
    set jobAttempts(value: number);
    resetJobAttempts(): void;
    get jobAttemptsInput(): number | undefined;
    private _jobDefinition?;
    get jobDefinition(): string;
    set jobDefinition(value: string);
    get jobDefinitionInput(): string | undefined;
    private _jobName?;
    get jobName(): string;
    set jobName(value: string);
    get jobNameInput(): string | undefined;
}
export interface CloudwatchEventTargetDeadLetterConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#arn CloudwatchEventTarget#arn}
    */
    readonly arn?: string;
}
export declare function cloudwatchEventTargetDeadLetterConfigToTerraform(struct?: CloudwatchEventTargetDeadLetterConfigOutputReference | CloudwatchEventTargetDeadLetterConfig): any;
export declare class CloudwatchEventTargetDeadLetterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudwatchEventTargetDeadLetterConfig | undefined;
    set internalValue(value: CloudwatchEventTargetDeadLetterConfig | undefined);
    private _arn?;
    get arn(): string;
    set arn(value: string);
    resetArn(): void;
    get arnInput(): string | undefined;
}
export interface CloudwatchEventTargetEcsTargetNetworkConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#assign_public_ip CloudwatchEventTarget#assign_public_ip}
    */
    readonly assignPublicIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#security_groups CloudwatchEventTarget#security_groups}
    */
    readonly securityGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#subnets CloudwatchEventTarget#subnets}
    */
    readonly subnets: string[];
}
export declare function cloudwatchEventTargetEcsTargetNetworkConfigurationToTerraform(struct?: CloudwatchEventTargetEcsTargetNetworkConfigurationOutputReference | CloudwatchEventTargetEcsTargetNetworkConfiguration): any;
export declare class CloudwatchEventTargetEcsTargetNetworkConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudwatchEventTargetEcsTargetNetworkConfiguration | undefined;
    set internalValue(value: CloudwatchEventTargetEcsTargetNetworkConfiguration | undefined);
    private _assignPublicIp?;
    get assignPublicIp(): boolean | cdktf.IResolvable;
    set assignPublicIp(value: boolean | cdktf.IResolvable);
    resetAssignPublicIp(): void;
    get assignPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _securityGroups?;
    get securityGroups(): string[];
    set securityGroups(value: string[]);
    resetSecurityGroups(): void;
    get securityGroupsInput(): string[] | undefined;
    private _subnets?;
    get subnets(): string[];
    set subnets(value: string[]);
    get subnetsInput(): string[] | undefined;
}
export interface CloudwatchEventTargetEcsTargetPlacementConstraint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#expression CloudwatchEventTarget#expression}
    */
    readonly expression?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#type CloudwatchEventTarget#type}
    */
    readonly type: string;
}
export declare function cloudwatchEventTargetEcsTargetPlacementConstraintToTerraform(struct?: CloudwatchEventTargetEcsTargetPlacementConstraint | cdktf.IResolvable): any;
export interface CloudwatchEventTargetEcsTarget {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#enable_ecs_managed_tags CloudwatchEventTarget#enable_ecs_managed_tags}
    */
    readonly enableEcsManagedTags?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#enable_execute_command CloudwatchEventTarget#enable_execute_command}
    */
    readonly enableExecuteCommand?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#group CloudwatchEventTarget#group}
    */
    readonly group?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#launch_type CloudwatchEventTarget#launch_type}
    */
    readonly launchType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#platform_version CloudwatchEventTarget#platform_version}
    */
    readonly platformVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#propagate_tags CloudwatchEventTarget#propagate_tags}
    */
    readonly propagateTags?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#tags CloudwatchEventTarget#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#task_count CloudwatchEventTarget#task_count}
    */
    readonly taskCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#task_definition_arn CloudwatchEventTarget#task_definition_arn}
    */
    readonly taskDefinitionArn: string;
    /**
    * network_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#network_configuration CloudwatchEventTarget#network_configuration}
    */
    readonly networkConfiguration?: CloudwatchEventTargetEcsTargetNetworkConfiguration;
    /**
    * placement_constraint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#placement_constraint CloudwatchEventTarget#placement_constraint}
    */
    readonly placementConstraint?: CloudwatchEventTargetEcsTargetPlacementConstraint[] | cdktf.IResolvable;
}
export declare function cloudwatchEventTargetEcsTargetToTerraform(struct?: CloudwatchEventTargetEcsTargetOutputReference | CloudwatchEventTargetEcsTarget): any;
export declare class CloudwatchEventTargetEcsTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudwatchEventTargetEcsTarget | undefined;
    set internalValue(value: CloudwatchEventTargetEcsTarget | undefined);
    private _enableEcsManagedTags?;
    get enableEcsManagedTags(): boolean | cdktf.IResolvable;
    set enableEcsManagedTags(value: boolean | cdktf.IResolvable);
    resetEnableEcsManagedTags(): void;
    get enableEcsManagedTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _enableExecuteCommand?;
    get enableExecuteCommand(): boolean | cdktf.IResolvable;
    set enableExecuteCommand(value: boolean | cdktf.IResolvable);
    resetEnableExecuteCommand(): void;
    get enableExecuteCommandInput(): boolean | cdktf.IResolvable | undefined;
    private _group?;
    get group(): string;
    set group(value: string);
    resetGroup(): void;
    get groupInput(): string | undefined;
    private _launchType?;
    get launchType(): string;
    set launchType(value: string);
    resetLaunchType(): void;
    get launchTypeInput(): string | undefined;
    private _platformVersion?;
    get platformVersion(): string;
    set platformVersion(value: string);
    resetPlatformVersion(): void;
    get platformVersionInput(): string | undefined;
    private _propagateTags?;
    get propagateTags(): string;
    set propagateTags(value: string);
    resetPropagateTags(): void;
    get propagateTagsInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _taskCount?;
    get taskCount(): number;
    set taskCount(value: number);
    resetTaskCount(): void;
    get taskCountInput(): number | undefined;
    private _taskDefinitionArn?;
    get taskDefinitionArn(): string;
    set taskDefinitionArn(value: string);
    get taskDefinitionArnInput(): string | undefined;
    private _networkConfiguration;
    get networkConfiguration(): CloudwatchEventTargetEcsTargetNetworkConfigurationOutputReference;
    putNetworkConfiguration(value: CloudwatchEventTargetEcsTargetNetworkConfiguration): void;
    resetNetworkConfiguration(): void;
    get networkConfigurationInput(): CloudwatchEventTargetEcsTargetNetworkConfiguration | undefined;
    private _placementConstraint?;
    get placementConstraint(): CloudwatchEventTargetEcsTargetPlacementConstraint[] | cdktf.IResolvable;
    set placementConstraint(value: CloudwatchEventTargetEcsTargetPlacementConstraint[] | cdktf.IResolvable);
    resetPlacementConstraint(): void;
    get placementConstraintInput(): cdktf.IResolvable | CloudwatchEventTargetEcsTargetPlacementConstraint[] | undefined;
}
export interface CloudwatchEventTargetHttpTarget {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#header_parameters CloudwatchEventTarget#header_parameters}
    */
    readonly headerParameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#path_parameter_values CloudwatchEventTarget#path_parameter_values}
    */
    readonly pathParameterValues?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#query_string_parameters CloudwatchEventTarget#query_string_parameters}
    */
    readonly queryStringParameters?: {
        [key: string]: string;
    };
}
export declare function cloudwatchEventTargetHttpTargetToTerraform(struct?: CloudwatchEventTargetHttpTargetOutputReference | CloudwatchEventTargetHttpTarget): any;
export declare class CloudwatchEventTargetHttpTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudwatchEventTargetHttpTarget | undefined;
    set internalValue(value: CloudwatchEventTargetHttpTarget | undefined);
    private _headerParameters?;
    get headerParameters(): {
        [key: string]: string;
    };
    set headerParameters(value: {
        [key: string]: string;
    });
    resetHeaderParameters(): void;
    get headerParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _pathParameterValues?;
    get pathParameterValues(): string[];
    set pathParameterValues(value: string[]);
    resetPathParameterValues(): void;
    get pathParameterValuesInput(): string[] | undefined;
    private _queryStringParameters?;
    get queryStringParameters(): {
        [key: string]: string;
    };
    set queryStringParameters(value: {
        [key: string]: string;
    });
    resetQueryStringParameters(): void;
    get queryStringParametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface CloudwatchEventTargetInputTransformer {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#input_paths CloudwatchEventTarget#input_paths}
    */
    readonly inputPaths?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#input_template CloudwatchEventTarget#input_template}
    */
    readonly inputTemplate: string;
}
export declare function cloudwatchEventTargetInputTransformerToTerraform(struct?: CloudwatchEventTargetInputTransformerOutputReference | CloudwatchEventTargetInputTransformer): any;
export declare class CloudwatchEventTargetInputTransformerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudwatchEventTargetInputTransformer | undefined;
    set internalValue(value: CloudwatchEventTargetInputTransformer | undefined);
    private _inputPaths?;
    get inputPaths(): {
        [key: string]: string;
    };
    set inputPaths(value: {
        [key: string]: string;
    });
    resetInputPaths(): void;
    get inputPathsInput(): {
        [key: string]: string;
    } | undefined;
    private _inputTemplate?;
    get inputTemplate(): string;
    set inputTemplate(value: string);
    get inputTemplateInput(): string | undefined;
}
export interface CloudwatchEventTargetKinesisTarget {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#partition_key_path CloudwatchEventTarget#partition_key_path}
    */
    readonly partitionKeyPath?: string;
}
export declare function cloudwatchEventTargetKinesisTargetToTerraform(struct?: CloudwatchEventTargetKinesisTargetOutputReference | CloudwatchEventTargetKinesisTarget): any;
export declare class CloudwatchEventTargetKinesisTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudwatchEventTargetKinesisTarget | undefined;
    set internalValue(value: CloudwatchEventTargetKinesisTarget | undefined);
    private _partitionKeyPath?;
    get partitionKeyPath(): string;
    set partitionKeyPath(value: string);
    resetPartitionKeyPath(): void;
    get partitionKeyPathInput(): string | undefined;
}
export interface CloudwatchEventTargetRedshiftTarget {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#database CloudwatchEventTarget#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#db_user CloudwatchEventTarget#db_user}
    */
    readonly dbUser?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#secrets_manager_arn CloudwatchEventTarget#secrets_manager_arn}
    */
    readonly secretsManagerArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#sql CloudwatchEventTarget#sql}
    */
    readonly sql?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#statement_name CloudwatchEventTarget#statement_name}
    */
    readonly statementName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#with_event CloudwatchEventTarget#with_event}
    */
    readonly withEvent?: boolean | cdktf.IResolvable;
}
export declare function cloudwatchEventTargetRedshiftTargetToTerraform(struct?: CloudwatchEventTargetRedshiftTargetOutputReference | CloudwatchEventTargetRedshiftTarget): any;
export declare class CloudwatchEventTargetRedshiftTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudwatchEventTargetRedshiftTarget | undefined;
    set internalValue(value: CloudwatchEventTargetRedshiftTarget | undefined);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _dbUser?;
    get dbUser(): string;
    set dbUser(value: string);
    resetDbUser(): void;
    get dbUserInput(): string | undefined;
    private _secretsManagerArn?;
    get secretsManagerArn(): string;
    set secretsManagerArn(value: string);
    resetSecretsManagerArn(): void;
    get secretsManagerArnInput(): string | undefined;
    private _sql?;
    get sql(): string;
    set sql(value: string);
    resetSql(): void;
    get sqlInput(): string | undefined;
    private _statementName?;
    get statementName(): string;
    set statementName(value: string);
    resetStatementName(): void;
    get statementNameInput(): string | undefined;
    private _withEvent?;
    get withEvent(): boolean | cdktf.IResolvable;
    set withEvent(value: boolean | cdktf.IResolvable);
    resetWithEvent(): void;
    get withEventInput(): boolean | cdktf.IResolvable | undefined;
}
export interface CloudwatchEventTargetRetryPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#maximum_event_age_in_seconds CloudwatchEventTarget#maximum_event_age_in_seconds}
    */
    readonly maximumEventAgeInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#maximum_retry_attempts CloudwatchEventTarget#maximum_retry_attempts}
    */
    readonly maximumRetryAttempts?: number;
}
export declare function cloudwatchEventTargetRetryPolicyToTerraform(struct?: CloudwatchEventTargetRetryPolicyOutputReference | CloudwatchEventTargetRetryPolicy): any;
export declare class CloudwatchEventTargetRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudwatchEventTargetRetryPolicy | undefined;
    set internalValue(value: CloudwatchEventTargetRetryPolicy | undefined);
    private _maximumEventAgeInSeconds?;
    get maximumEventAgeInSeconds(): number;
    set maximumEventAgeInSeconds(value: number);
    resetMaximumEventAgeInSeconds(): void;
    get maximumEventAgeInSecondsInput(): number | undefined;
    private _maximumRetryAttempts?;
    get maximumRetryAttempts(): number;
    set maximumRetryAttempts(value: number);
    resetMaximumRetryAttempts(): void;
    get maximumRetryAttemptsInput(): number | undefined;
}
export interface CloudwatchEventTargetRunCommandTargets {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#key CloudwatchEventTarget#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#values CloudwatchEventTarget#values}
    */
    readonly values: string[];
}
export declare function cloudwatchEventTargetRunCommandTargetsToTerraform(struct?: CloudwatchEventTargetRunCommandTargets | cdktf.IResolvable): any;
export interface CloudwatchEventTargetSqsTarget {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target#message_group_id CloudwatchEventTarget#message_group_id}
    */
    readonly messageGroupId?: string;
}
export declare function cloudwatchEventTargetSqsTargetToTerraform(struct?: CloudwatchEventTargetSqsTargetOutputReference | CloudwatchEventTargetSqsTarget): any;
export declare class CloudwatchEventTargetSqsTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudwatchEventTargetSqsTarget | undefined;
    set internalValue(value: CloudwatchEventTargetSqsTarget | undefined);
    private _messageGroupId?;
    get messageGroupId(): string;
    set messageGroupId(value: string);
    resetMessageGroupId(): void;
    get messageGroupIdInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target aws_cloudwatch_event_target}
*/
export declare class CloudwatchEventTarget extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_cloudwatch_event_target";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/cloudwatch_event_target aws_cloudwatch_event_target} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudwatchEventTargetConfig
    */
    constructor(scope: Construct, id: string, config: CloudwatchEventTargetConfig);
    private _arn?;
    get arn(): string;
    set arn(value: string);
    get arnInput(): string | undefined;
    private _eventBusName?;
    get eventBusName(): string;
    set eventBusName(value: string);
    resetEventBusName(): void;
    get eventBusNameInput(): string | undefined;
    get id(): string;
    private _input?;
    get input(): string;
    set input(value: string);
    resetInput(): void;
    get inputInput(): string | undefined;
    private _inputPath?;
    get inputPath(): string;
    set inputPath(value: string);
    resetInputPath(): void;
    get inputPathInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    resetRoleArn(): void;
    get roleArnInput(): string | undefined;
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
    private _targetId?;
    get targetId(): string;
    set targetId(value: string);
    resetTargetId(): void;
    get targetIdInput(): string | undefined;
    private _batchTarget;
    get batchTarget(): CloudwatchEventTargetBatchTargetOutputReference;
    putBatchTarget(value: CloudwatchEventTargetBatchTarget): void;
    resetBatchTarget(): void;
    get batchTargetInput(): CloudwatchEventTargetBatchTarget | undefined;
    private _deadLetterConfig;
    get deadLetterConfig(): CloudwatchEventTargetDeadLetterConfigOutputReference;
    putDeadLetterConfig(value: CloudwatchEventTargetDeadLetterConfig): void;
    resetDeadLetterConfig(): void;
    get deadLetterConfigInput(): CloudwatchEventTargetDeadLetterConfig | undefined;
    private _ecsTarget;
    get ecsTarget(): CloudwatchEventTargetEcsTargetOutputReference;
    putEcsTarget(value: CloudwatchEventTargetEcsTarget): void;
    resetEcsTarget(): void;
    get ecsTargetInput(): CloudwatchEventTargetEcsTarget | undefined;
    private _httpTarget;
    get httpTarget(): CloudwatchEventTargetHttpTargetOutputReference;
    putHttpTarget(value: CloudwatchEventTargetHttpTarget): void;
    resetHttpTarget(): void;
    get httpTargetInput(): CloudwatchEventTargetHttpTarget | undefined;
    private _inputTransformer;
    get inputTransformer(): CloudwatchEventTargetInputTransformerOutputReference;
    putInputTransformer(value: CloudwatchEventTargetInputTransformer): void;
    resetInputTransformer(): void;
    get inputTransformerInput(): CloudwatchEventTargetInputTransformer | undefined;
    private _kinesisTarget;
    get kinesisTarget(): CloudwatchEventTargetKinesisTargetOutputReference;
    putKinesisTarget(value: CloudwatchEventTargetKinesisTarget): void;
    resetKinesisTarget(): void;
    get kinesisTargetInput(): CloudwatchEventTargetKinesisTarget | undefined;
    private _redshiftTarget;
    get redshiftTarget(): CloudwatchEventTargetRedshiftTargetOutputReference;
    putRedshiftTarget(value: CloudwatchEventTargetRedshiftTarget): void;
    resetRedshiftTarget(): void;
    get redshiftTargetInput(): CloudwatchEventTargetRedshiftTarget | undefined;
    private _retryPolicy;
    get retryPolicy(): CloudwatchEventTargetRetryPolicyOutputReference;
    putRetryPolicy(value: CloudwatchEventTargetRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): CloudwatchEventTargetRetryPolicy | undefined;
    private _runCommandTargets?;
    get runCommandTargets(): CloudwatchEventTargetRunCommandTargets[] | cdktf.IResolvable;
    set runCommandTargets(value: CloudwatchEventTargetRunCommandTargets[] | cdktf.IResolvable);
    resetRunCommandTargets(): void;
    get runCommandTargetsInput(): cdktf.IResolvable | CloudwatchEventTargetRunCommandTargets[] | undefined;
    private _sqsTarget;
    get sqsTarget(): CloudwatchEventTargetSqsTargetOutputReference;
    putSqsTarget(value: CloudwatchEventTargetSqsTarget): void;
    resetSqsTarget(): void;
    get sqsTargetInput(): CloudwatchEventTargetSqsTarget | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=cloudwatch-event-target.d.ts.map