import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS CloudWatch Event Bridge
*/
export interface DataAwsCloudwatchEventBusConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/cloudwatch_event_bus#name DataAwsCloudwatchEventBus#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/cloudwatch_event_bus aws_cloudwatch_event_bus}
*/
export declare class DataAwsCloudwatchEventBus extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_cloudwatch_event_bus";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/cloudwatch_event_bus aws_cloudwatch_event_bus} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsCloudwatchEventBusConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsCloudwatchEventBusConfig);
    get arn(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-cloudwatch-event-bus.d.ts.map