import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Firewall Management Service
*/
export interface FmsAdminAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fms_admin_account#account_id FmsAdminAccount#account_id}
    */
    readonly accountId?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/fms_admin_account aws_fms_admin_account}
*/
export declare class FmsAdminAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_fms_admin_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/fms_admin_account aws_fms_admin_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FmsAdminAccountConfig = {}
    */
    constructor(scope: Construct, id: string, config?: FmsAdminAccountConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    resetAccountId(): void;
    get accountIdInput(): string | undefined;
    get id(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=fms-admin-account.d.ts.map