import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS File System FSx
*/
export interface FsxOpenzfsVolumeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#copy_tags_to_snapshots FsxOpenzfsVolume#copy_tags_to_snapshots}
    */
    readonly copyTagsToSnapshots?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#data_compression_type FsxOpenzfsVolume#data_compression_type}
    */
    readonly dataCompressionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#name FsxOpenzfsVolume#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#parent_volume_id FsxOpenzfsVolume#parent_volume_id}
    */
    readonly parentVolumeId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#read_only FsxOpenzfsVolume#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#storage_capacity_quota_gib FsxOpenzfsVolume#storage_capacity_quota_gib}
    */
    readonly storageCapacityQuotaGib?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#storage_capacity_reservation_gib FsxOpenzfsVolume#storage_capacity_reservation_gib}
    */
    readonly storageCapacityReservationGib?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#tags FsxOpenzfsVolume#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#tags_all FsxOpenzfsVolume#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#volume_type FsxOpenzfsVolume#volume_type}
    */
    readonly volumeType?: string;
    /**
    * nfs_exports block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#nfs_exports FsxOpenzfsVolume#nfs_exports}
    */
    readonly nfsExports?: FsxOpenzfsVolumeNfsExports;
    /**
    * origin_snapshot block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#origin_snapshot FsxOpenzfsVolume#origin_snapshot}
    */
    readonly originSnapshot?: FsxOpenzfsVolumeOriginSnapshot;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#timeouts FsxOpenzfsVolume#timeouts}
    */
    readonly timeouts?: FsxOpenzfsVolumeTimeouts;
    /**
    * user_and_group_quotas block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#user_and_group_quotas FsxOpenzfsVolume#user_and_group_quotas}
    */
    readonly userAndGroupQuotas?: FsxOpenzfsVolumeUserAndGroupQuotas[] | cdktf.IResolvable;
}
export interface FsxOpenzfsVolumeNfsExportsClientConfigurations {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#clients FsxOpenzfsVolume#clients}
    */
    readonly clients: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#options FsxOpenzfsVolume#options}
    */
    readonly options: string[];
}
export declare function fsxOpenzfsVolumeNfsExportsClientConfigurationsToTerraform(struct?: FsxOpenzfsVolumeNfsExportsClientConfigurations | cdktf.IResolvable): any;
export interface FsxOpenzfsVolumeNfsExports {
    /**
    * client_configurations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#client_configurations FsxOpenzfsVolume#client_configurations}
    */
    readonly clientConfigurations: FsxOpenzfsVolumeNfsExportsClientConfigurations[] | cdktf.IResolvable;
}
export declare function fsxOpenzfsVolumeNfsExportsToTerraform(struct?: FsxOpenzfsVolumeNfsExportsOutputReference | FsxOpenzfsVolumeNfsExports): any;
export declare class FsxOpenzfsVolumeNfsExportsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FsxOpenzfsVolumeNfsExports | undefined;
    set internalValue(value: FsxOpenzfsVolumeNfsExports | undefined);
    private _clientConfigurations?;
    get clientConfigurations(): FsxOpenzfsVolumeNfsExportsClientConfigurations[] | cdktf.IResolvable;
    set clientConfigurations(value: FsxOpenzfsVolumeNfsExportsClientConfigurations[] | cdktf.IResolvable);
    get clientConfigurationsInput(): cdktf.IResolvable | FsxOpenzfsVolumeNfsExportsClientConfigurations[] | undefined;
}
export interface FsxOpenzfsVolumeOriginSnapshot {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#copy_strategy FsxOpenzfsVolume#copy_strategy}
    */
    readonly copyStrategy: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#snapshot_arn FsxOpenzfsVolume#snapshot_arn}
    */
    readonly snapshotArn: string;
}
export declare function fsxOpenzfsVolumeOriginSnapshotToTerraform(struct?: FsxOpenzfsVolumeOriginSnapshotOutputReference | FsxOpenzfsVolumeOriginSnapshot): any;
export declare class FsxOpenzfsVolumeOriginSnapshotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FsxOpenzfsVolumeOriginSnapshot | undefined;
    set internalValue(value: FsxOpenzfsVolumeOriginSnapshot | undefined);
    private _copyStrategy?;
    get copyStrategy(): string;
    set copyStrategy(value: string);
    get copyStrategyInput(): string | undefined;
    private _snapshotArn?;
    get snapshotArn(): string;
    set snapshotArn(value: string);
    get snapshotArnInput(): string | undefined;
}
export interface FsxOpenzfsVolumeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#create FsxOpenzfsVolume#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#delete FsxOpenzfsVolume#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#update FsxOpenzfsVolume#update}
    */
    readonly update?: string;
}
export declare function fsxOpenzfsVolumeTimeoutsToTerraform(struct?: FsxOpenzfsVolumeTimeoutsOutputReference | FsxOpenzfsVolumeTimeouts | cdktf.IResolvable): any;
export declare class FsxOpenzfsVolumeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FsxOpenzfsVolumeTimeouts | undefined;
    set internalValue(value: FsxOpenzfsVolumeTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface FsxOpenzfsVolumeUserAndGroupQuotas {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#id FsxOpenzfsVolume#id}
    */
    readonly id: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#storage_capacity_quota_gib FsxOpenzfsVolume#storage_capacity_quota_gib}
    */
    readonly storageCapacityQuotaGib: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume#type FsxOpenzfsVolume#type}
    */
    readonly type: string;
}
export declare function fsxOpenzfsVolumeUserAndGroupQuotasToTerraform(struct?: FsxOpenzfsVolumeUserAndGroupQuotas | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume aws_fsx_openzfs_volume}
*/
export declare class FsxOpenzfsVolume extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_fsx_openzfs_volume";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/fsx_openzfs_volume aws_fsx_openzfs_volume} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FsxOpenzfsVolumeConfig
    */
    constructor(scope: Construct, id: string, config: FsxOpenzfsVolumeConfig);
    get arn(): string;
    private _copyTagsToSnapshots?;
    get copyTagsToSnapshots(): boolean | cdktf.IResolvable;
    set copyTagsToSnapshots(value: boolean | cdktf.IResolvable);
    resetCopyTagsToSnapshots(): void;
    get copyTagsToSnapshotsInput(): boolean | cdktf.IResolvable | undefined;
    private _dataCompressionType?;
    get dataCompressionType(): string;
    set dataCompressionType(value: string);
    resetDataCompressionType(): void;
    get dataCompressionTypeInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parentVolumeId?;
    get parentVolumeId(): string;
    set parentVolumeId(value: string);
    get parentVolumeIdInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _storageCapacityQuotaGib?;
    get storageCapacityQuotaGib(): number;
    set storageCapacityQuotaGib(value: number);
    resetStorageCapacityQuotaGib(): void;
    get storageCapacityQuotaGibInput(): number | undefined;
    private _storageCapacityReservationGib?;
    get storageCapacityReservationGib(): number;
    set storageCapacityReservationGib(value: number);
    resetStorageCapacityReservationGib(): void;
    get storageCapacityReservationGibInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    resetVolumeType(): void;
    get volumeTypeInput(): string | undefined;
    private _nfsExports;
    get nfsExports(): FsxOpenzfsVolumeNfsExportsOutputReference;
    putNfsExports(value: FsxOpenzfsVolumeNfsExports): void;
    resetNfsExports(): void;
    get nfsExportsInput(): FsxOpenzfsVolumeNfsExports | undefined;
    private _originSnapshot;
    get originSnapshot(): FsxOpenzfsVolumeOriginSnapshotOutputReference;
    putOriginSnapshot(value: FsxOpenzfsVolumeOriginSnapshot): void;
    resetOriginSnapshot(): void;
    get originSnapshotInput(): FsxOpenzfsVolumeOriginSnapshot | undefined;
    private _timeouts;
    get timeouts(): FsxOpenzfsVolumeTimeoutsOutputReference;
    putTimeouts(value: FsxOpenzfsVolumeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): FsxOpenzfsVolumeTimeouts | undefined;
    private _userAndGroupQuotas?;
    get userAndGroupQuotas(): FsxOpenzfsVolumeUserAndGroupQuotas[] | cdktf.IResolvable;
    set userAndGroupQuotas(value: FsxOpenzfsVolumeUserAndGroupQuotas[] | cdktf.IResolvable);
    resetUserAndGroupQuotas(): void;
    get userAndGroupQuotasInput(): cdktf.IResolvable | FsxOpenzfsVolumeUserAndGroupQuotas[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=fsx-openzfs-volume.d.ts.map