import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Global Accelerator
*/
export interface DataAwsGlobalacceleratorAcceleratorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/globalaccelerator_accelerator#arn DataAwsGlobalacceleratorAccelerator#arn}
    */
    readonly arn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/globalaccelerator_accelerator#name DataAwsGlobalacceleratorAccelerator#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/globalaccelerator_accelerator#tags DataAwsGlobalacceleratorAccelerator#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataAwsGlobalacceleratorAcceleratorAttributes {
}
export declare function dataAwsGlobalacceleratorAcceleratorAttributesToTerraform(struct?: DataAwsGlobalacceleratorAcceleratorAttributes): any;
export declare class DataAwsGlobalacceleratorAcceleratorAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsGlobalacceleratorAcceleratorAttributes | undefined;
    set internalValue(value: DataAwsGlobalacceleratorAcceleratorAttributes | undefined);
    get flowLogsEnabled(): cdktf.IResolvable;
    get flowLogsS3Bucket(): string;
    get flowLogsS3Prefix(): string;
}
export declare class DataAwsGlobalacceleratorAcceleratorAttributesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsGlobalacceleratorAcceleratorAttributesOutputReference;
}
export interface DataAwsGlobalacceleratorAcceleratorIpSets {
}
export declare function dataAwsGlobalacceleratorAcceleratorIpSetsToTerraform(struct?: DataAwsGlobalacceleratorAcceleratorIpSets): any;
export declare class DataAwsGlobalacceleratorAcceleratorIpSetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsGlobalacceleratorAcceleratorIpSets | undefined;
    set internalValue(value: DataAwsGlobalacceleratorAcceleratorIpSets | undefined);
    get ipAddresses(): string[];
    get ipFamily(): string;
}
export declare class DataAwsGlobalacceleratorAcceleratorIpSetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsGlobalacceleratorAcceleratorIpSetsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/globalaccelerator_accelerator aws_globalaccelerator_accelerator}
*/
export declare class DataAwsGlobalacceleratorAccelerator extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_globalaccelerator_accelerator";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/globalaccelerator_accelerator aws_globalaccelerator_accelerator} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsGlobalacceleratorAcceleratorConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsGlobalacceleratorAcceleratorConfig);
    private _arn?;
    get arn(): string;
    set arn(value: string);
    resetArn(): void;
    get arnInput(): string | undefined;
    private _attributes;
    get attributes(): DataAwsGlobalacceleratorAcceleratorAttributesList;
    get dnsName(): string;
    get enabled(): cdktf.IResolvable;
    get hostedZoneId(): string;
    get id(): string;
    get ipAddressType(): string;
    private _ipSets;
    get ipSets(): DataAwsGlobalacceleratorAcceleratorIpSetsList;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-globalaccelerator-accelerator.d.ts.map