import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Glue
*/
export interface DataAwsGlueConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/glue_connection#id DataAwsGlueConnection#id}
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/glue_connection#tags DataAwsGlueConnection#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataAwsGlueConnectionPhysicalConnectionRequirements {
}
export declare function dataAwsGlueConnectionPhysicalConnectionRequirementsToTerraform(struct?: DataAwsGlueConnectionPhysicalConnectionRequirements): any;
export declare class DataAwsGlueConnectionPhysicalConnectionRequirementsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsGlueConnectionPhysicalConnectionRequirements | undefined;
    set internalValue(value: DataAwsGlueConnectionPhysicalConnectionRequirements | undefined);
    get availabilityZone(): string;
    get securityGroupIdList(): string[];
    get subnetId(): string;
}
export declare class DataAwsGlueConnectionPhysicalConnectionRequirementsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsGlueConnectionPhysicalConnectionRequirementsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/glue_connection aws_glue_connection}
*/
export declare class DataAwsGlueConnection extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_glue_connection";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/glue_connection aws_glue_connection} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsGlueConnectionConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsGlueConnectionConfig);
    get arn(): string;
    get catalogId(): string;
    connectionProperties(key: string): string | cdktf.IResolvable;
    get connectionType(): string;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    get matchCriteria(): string[];
    get name(): string;
    private _physicalConnectionRequirements;
    get physicalConnectionRequirements(): DataAwsGlueConnectionPhysicalConnectionRequirementsList;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-glue-connection.d.ts.map