import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Glue
*/
export interface DataAwsGlueScriptConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/glue_script#language DataAwsGlueScript#language}
    */
    readonly language?: string;
    /**
    * dag_edge block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/glue_script#dag_edge DataAwsGlueScript#dag_edge}
    */
    readonly dagEdge: DataAwsGlueScriptDagEdge[] | cdktf.IResolvable;
    /**
    * dag_node block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/glue_script#dag_node DataAwsGlueScript#dag_node}
    */
    readonly dagNode: DataAwsGlueScriptDagNode[] | cdktf.IResolvable;
}
export interface DataAwsGlueScriptDagEdge {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/glue_script#source DataAwsGlueScript#source}
    */
    readonly source: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/glue_script#target DataAwsGlueScript#target}
    */
    readonly target: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/glue_script#target_parameter DataAwsGlueScript#target_parameter}
    */
    readonly targetParameter?: string;
}
export declare function dataAwsGlueScriptDagEdgeToTerraform(struct?: DataAwsGlueScriptDagEdge | cdktf.IResolvable): any;
export interface DataAwsGlueScriptDagNodeArgs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/glue_script#name DataAwsGlueScript#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/glue_script#param DataAwsGlueScript#param}
    */
    readonly param?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/glue_script#value DataAwsGlueScript#value}
    */
    readonly value: string;
}
export declare function dataAwsGlueScriptDagNodeArgsToTerraform(struct?: DataAwsGlueScriptDagNodeArgs | cdktf.IResolvable): any;
export interface DataAwsGlueScriptDagNode {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/glue_script#id DataAwsGlueScript#id}
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/glue_script#line_number DataAwsGlueScript#line_number}
    */
    readonly lineNumber?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/glue_script#node_type DataAwsGlueScript#node_type}
    */
    readonly nodeType: string;
    /**
    * args block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/glue_script#args DataAwsGlueScript#args}
    */
    readonly args: DataAwsGlueScriptDagNodeArgs[] | cdktf.IResolvable;
}
export declare function dataAwsGlueScriptDagNodeToTerraform(struct?: DataAwsGlueScriptDagNode | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/glue_script aws_glue_script}
*/
export declare class DataAwsGlueScript extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_glue_script";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/glue_script aws_glue_script} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsGlueScriptConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsGlueScriptConfig);
    get id(): string;
    private _language?;
    get language(): string;
    set language(value: string);
    resetLanguage(): void;
    get languageInput(): string | undefined;
    get pythonScript(): string;
    get scalaCode(): string;
    private _dagEdge?;
    get dagEdge(): DataAwsGlueScriptDagEdge[] | cdktf.IResolvable;
    set dagEdge(value: DataAwsGlueScriptDagEdge[] | cdktf.IResolvable);
    get dagEdgeInput(): cdktf.IResolvable | DataAwsGlueScriptDagEdge[] | undefined;
    private _dagNode?;
    get dagNode(): DataAwsGlueScriptDagNode[] | cdktf.IResolvable;
    set dagNode(value: DataAwsGlueScriptDagNode[] | cdktf.IResolvable);
    get dagNodeInput(): cdktf.IResolvable | DataAwsGlueScriptDagNode[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-glue-script.d.ts.map