import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Glue
*/
export interface GlueCrawlerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#classifiers GlueCrawler#classifiers}
    */
    readonly classifiers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#configuration GlueCrawler#configuration}
    */
    readonly configuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#database_name GlueCrawler#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#description GlueCrawler#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#name GlueCrawler#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#role GlueCrawler#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#schedule GlueCrawler#schedule}
    */
    readonly schedule?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#security_configuration GlueCrawler#security_configuration}
    */
    readonly securityConfiguration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#table_prefix GlueCrawler#table_prefix}
    */
    readonly tablePrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#tags GlueCrawler#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#tags_all GlueCrawler#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * catalog_target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#catalog_target GlueCrawler#catalog_target}
    */
    readonly catalogTarget?: GlueCrawlerCatalogTarget[] | cdktf.IResolvable;
    /**
    * delta_target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#delta_target GlueCrawler#delta_target}
    */
    readonly deltaTarget?: GlueCrawlerDeltaTarget[] | cdktf.IResolvable;
    /**
    * dynamodb_target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#dynamodb_target GlueCrawler#dynamodb_target}
    */
    readonly dynamodbTarget?: GlueCrawlerDynamodbTarget[] | cdktf.IResolvable;
    /**
    * jdbc_target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#jdbc_target GlueCrawler#jdbc_target}
    */
    readonly jdbcTarget?: GlueCrawlerJdbcTarget[] | cdktf.IResolvable;
    /**
    * lineage_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#lineage_configuration GlueCrawler#lineage_configuration}
    */
    readonly lineageConfiguration?: GlueCrawlerLineageConfiguration;
    /**
    * mongodb_target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#mongodb_target GlueCrawler#mongodb_target}
    */
    readonly mongodbTarget?: GlueCrawlerMongodbTarget[] | cdktf.IResolvable;
    /**
    * recrawl_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#recrawl_policy GlueCrawler#recrawl_policy}
    */
    readonly recrawlPolicy?: GlueCrawlerRecrawlPolicy;
    /**
    * s3_target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#s3_target GlueCrawler#s3_target}
    */
    readonly s3Target?: GlueCrawlerS3Target[] | cdktf.IResolvable;
    /**
    * schema_change_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#schema_change_policy GlueCrawler#schema_change_policy}
    */
    readonly schemaChangePolicy?: GlueCrawlerSchemaChangePolicy;
}
export interface GlueCrawlerCatalogTarget {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#database_name GlueCrawler#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#tables GlueCrawler#tables}
    */
    readonly tables: string[];
}
export declare function glueCrawlerCatalogTargetToTerraform(struct?: GlueCrawlerCatalogTarget | cdktf.IResolvable): any;
export interface GlueCrawlerDeltaTarget {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#connection_name GlueCrawler#connection_name}
    */
    readonly connectionName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#delta_tables GlueCrawler#delta_tables}
    */
    readonly deltaTables: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#write_manifest GlueCrawler#write_manifest}
    */
    readonly writeManifest: boolean | cdktf.IResolvable;
}
export declare function glueCrawlerDeltaTargetToTerraform(struct?: GlueCrawlerDeltaTarget | cdktf.IResolvable): any;
export interface GlueCrawlerDynamodbTarget {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#path GlueCrawler#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#scan_all GlueCrawler#scan_all}
    */
    readonly scanAll?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#scan_rate GlueCrawler#scan_rate}
    */
    readonly scanRate?: number;
}
export declare function glueCrawlerDynamodbTargetToTerraform(struct?: GlueCrawlerDynamodbTarget | cdktf.IResolvable): any;
export interface GlueCrawlerJdbcTarget {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#connection_name GlueCrawler#connection_name}
    */
    readonly connectionName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#exclusions GlueCrawler#exclusions}
    */
    readonly exclusions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#path GlueCrawler#path}
    */
    readonly path: string;
}
export declare function glueCrawlerJdbcTargetToTerraform(struct?: GlueCrawlerJdbcTarget | cdktf.IResolvable): any;
export interface GlueCrawlerLineageConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#crawler_lineage_settings GlueCrawler#crawler_lineage_settings}
    */
    readonly crawlerLineageSettings?: string;
}
export declare function glueCrawlerLineageConfigurationToTerraform(struct?: GlueCrawlerLineageConfigurationOutputReference | GlueCrawlerLineageConfiguration): any;
export declare class GlueCrawlerLineageConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GlueCrawlerLineageConfiguration | undefined;
    set internalValue(value: GlueCrawlerLineageConfiguration | undefined);
    private _crawlerLineageSettings?;
    get crawlerLineageSettings(): string;
    set crawlerLineageSettings(value: string);
    resetCrawlerLineageSettings(): void;
    get crawlerLineageSettingsInput(): string | undefined;
}
export interface GlueCrawlerMongodbTarget {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#connection_name GlueCrawler#connection_name}
    */
    readonly connectionName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#path GlueCrawler#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#scan_all GlueCrawler#scan_all}
    */
    readonly scanAll?: boolean | cdktf.IResolvable;
}
export declare function glueCrawlerMongodbTargetToTerraform(struct?: GlueCrawlerMongodbTarget | cdktf.IResolvable): any;
export interface GlueCrawlerRecrawlPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#recrawl_behavior GlueCrawler#recrawl_behavior}
    */
    readonly recrawlBehavior?: string;
}
export declare function glueCrawlerRecrawlPolicyToTerraform(struct?: GlueCrawlerRecrawlPolicyOutputReference | GlueCrawlerRecrawlPolicy): any;
export declare class GlueCrawlerRecrawlPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GlueCrawlerRecrawlPolicy | undefined;
    set internalValue(value: GlueCrawlerRecrawlPolicy | undefined);
    private _recrawlBehavior?;
    get recrawlBehavior(): string;
    set recrawlBehavior(value: string);
    resetRecrawlBehavior(): void;
    get recrawlBehaviorInput(): string | undefined;
}
export interface GlueCrawlerS3Target {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#connection_name GlueCrawler#connection_name}
    */
    readonly connectionName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#dlq_event_queue_arn GlueCrawler#dlq_event_queue_arn}
    */
    readonly dlqEventQueueArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#event_queue_arn GlueCrawler#event_queue_arn}
    */
    readonly eventQueueArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#exclusions GlueCrawler#exclusions}
    */
    readonly exclusions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#path GlueCrawler#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#sample_size GlueCrawler#sample_size}
    */
    readonly sampleSize?: number;
}
export declare function glueCrawlerS3TargetToTerraform(struct?: GlueCrawlerS3Target | cdktf.IResolvable): any;
export interface GlueCrawlerSchemaChangePolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#delete_behavior GlueCrawler#delete_behavior}
    */
    readonly deleteBehavior?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler#update_behavior GlueCrawler#update_behavior}
    */
    readonly updateBehavior?: string;
}
export declare function glueCrawlerSchemaChangePolicyToTerraform(struct?: GlueCrawlerSchemaChangePolicyOutputReference | GlueCrawlerSchemaChangePolicy): any;
export declare class GlueCrawlerSchemaChangePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GlueCrawlerSchemaChangePolicy | undefined;
    set internalValue(value: GlueCrawlerSchemaChangePolicy | undefined);
    private _deleteBehavior?;
    get deleteBehavior(): string;
    set deleteBehavior(value: string);
    resetDeleteBehavior(): void;
    get deleteBehaviorInput(): string | undefined;
    private _updateBehavior?;
    get updateBehavior(): string;
    set updateBehavior(value: string);
    resetUpdateBehavior(): void;
    get updateBehaviorInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler aws_glue_crawler}
*/
export declare class GlueCrawler extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_glue_crawler";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/glue_crawler aws_glue_crawler} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GlueCrawlerConfig
    */
    constructor(scope: Construct, id: string, config: GlueCrawlerConfig);
    get arn(): string;
    private _classifiers?;
    get classifiers(): string[];
    set classifiers(value: string[]);
    resetClassifiers(): void;
    get classifiersInput(): string[] | undefined;
    private _configuration?;
    get configuration(): string;
    set configuration(value: string);
    resetConfiguration(): void;
    get configurationInput(): string | undefined;
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _schedule?;
    get schedule(): string;
    set schedule(value: string);
    resetSchedule(): void;
    get scheduleInput(): string | undefined;
    private _securityConfiguration?;
    get securityConfiguration(): string;
    set securityConfiguration(value: string);
    resetSecurityConfiguration(): void;
    get securityConfigurationInput(): string | undefined;
    private _tablePrefix?;
    get tablePrefix(): string;
    set tablePrefix(value: string);
    resetTablePrefix(): void;
    get tablePrefixInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _catalogTarget?;
    get catalogTarget(): GlueCrawlerCatalogTarget[] | cdktf.IResolvable;
    set catalogTarget(value: GlueCrawlerCatalogTarget[] | cdktf.IResolvable);
    resetCatalogTarget(): void;
    get catalogTargetInput(): cdktf.IResolvable | GlueCrawlerCatalogTarget[] | undefined;
    private _deltaTarget?;
    get deltaTarget(): GlueCrawlerDeltaTarget[] | cdktf.IResolvable;
    set deltaTarget(value: GlueCrawlerDeltaTarget[] | cdktf.IResolvable);
    resetDeltaTarget(): void;
    get deltaTargetInput(): cdktf.IResolvable | GlueCrawlerDeltaTarget[] | undefined;
    private _dynamodbTarget?;
    get dynamodbTarget(): GlueCrawlerDynamodbTarget[] | cdktf.IResolvable;
    set dynamodbTarget(value: GlueCrawlerDynamodbTarget[] | cdktf.IResolvable);
    resetDynamodbTarget(): void;
    get dynamodbTargetInput(): cdktf.IResolvable | GlueCrawlerDynamodbTarget[] | undefined;
    private _jdbcTarget?;
    get jdbcTarget(): GlueCrawlerJdbcTarget[] | cdktf.IResolvable;
    set jdbcTarget(value: GlueCrawlerJdbcTarget[] | cdktf.IResolvable);
    resetJdbcTarget(): void;
    get jdbcTargetInput(): cdktf.IResolvable | GlueCrawlerJdbcTarget[] | undefined;
    private _lineageConfiguration;
    get lineageConfiguration(): GlueCrawlerLineageConfigurationOutputReference;
    putLineageConfiguration(value: GlueCrawlerLineageConfiguration): void;
    resetLineageConfiguration(): void;
    get lineageConfigurationInput(): GlueCrawlerLineageConfiguration | undefined;
    private _mongodbTarget?;
    get mongodbTarget(): GlueCrawlerMongodbTarget[] | cdktf.IResolvable;
    set mongodbTarget(value: GlueCrawlerMongodbTarget[] | cdktf.IResolvable);
    resetMongodbTarget(): void;
    get mongodbTargetInput(): cdktf.IResolvable | GlueCrawlerMongodbTarget[] | undefined;
    private _recrawlPolicy;
    get recrawlPolicy(): GlueCrawlerRecrawlPolicyOutputReference;
    putRecrawlPolicy(value: GlueCrawlerRecrawlPolicy): void;
    resetRecrawlPolicy(): void;
    get recrawlPolicyInput(): GlueCrawlerRecrawlPolicy | undefined;
    private _s3Target?;
    get s3Target(): GlueCrawlerS3Target[] | cdktf.IResolvable;
    set s3Target(value: GlueCrawlerS3Target[] | cdktf.IResolvable);
    resetS3Target(): void;
    get s3TargetInput(): cdktf.IResolvable | GlueCrawlerS3Target[] | undefined;
    private _schemaChangePolicy;
    get schemaChangePolicy(): GlueCrawlerSchemaChangePolicyOutputReference;
    putSchemaChangePolicy(value: GlueCrawlerSchemaChangePolicy): void;
    resetSchemaChangePolicy(): void;
    get schemaChangePolicyInput(): GlueCrawlerSchemaChangePolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=glue-crawler.d.ts.map