import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Glue
*/
export interface GlueUserDefinedFunctionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_user_defined_function#catalog_id GlueUserDefinedFunction#catalog_id}
    */
    readonly catalogId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_user_defined_function#class_name GlueUserDefinedFunction#class_name}
    */
    readonly className: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_user_defined_function#database_name GlueUserDefinedFunction#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_user_defined_function#name GlueUserDefinedFunction#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_user_defined_function#owner_name GlueUserDefinedFunction#owner_name}
    */
    readonly ownerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_user_defined_function#owner_type GlueUserDefinedFunction#owner_type}
    */
    readonly ownerType: string;
    /**
    * resource_uris block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_user_defined_function#resource_uris GlueUserDefinedFunction#resource_uris}
    */
    readonly resourceUris?: GlueUserDefinedFunctionResourceUris[] | cdktf.IResolvable;
}
export interface GlueUserDefinedFunctionResourceUris {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_user_defined_function#resource_type GlueUserDefinedFunction#resource_type}
    */
    readonly resourceType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/glue_user_defined_function#uri GlueUserDefinedFunction#uri}
    */
    readonly uri: string;
}
export declare function glueUserDefinedFunctionResourceUrisToTerraform(struct?: GlueUserDefinedFunctionResourceUris | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/glue_user_defined_function aws_glue_user_defined_function}
*/
export declare class GlueUserDefinedFunction extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_glue_user_defined_function";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/glue_user_defined_function aws_glue_user_defined_function} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GlueUserDefinedFunctionConfig
    */
    constructor(scope: Construct, id: string, config: GlueUserDefinedFunctionConfig);
    get arn(): string;
    private _catalogId?;
    get catalogId(): string;
    set catalogId(value: string);
    resetCatalogId(): void;
    get catalogIdInput(): string | undefined;
    private _className?;
    get className(): string;
    set className(value: string);
    get classNameInput(): string | undefined;
    get createTime(): string;
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ownerName?;
    get ownerName(): string;
    set ownerName(value: string);
    get ownerNameInput(): string | undefined;
    private _ownerType?;
    get ownerType(): string;
    set ownerType(value: string);
    get ownerTypeInput(): string | undefined;
    private _resourceUris?;
    get resourceUris(): GlueUserDefinedFunctionResourceUris[] | cdktf.IResolvable;
    set resourceUris(value: GlueUserDefinedFunctionResourceUris[] | cdktf.IResolvable);
    resetResourceUris(): void;
    get resourceUrisInput(): cdktf.IResolvable | GlueUserDefinedFunctionResourceUris[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=glue-user-defined-function.d.ts.map