import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GrafanaLicenseAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_license_association#license_type GrafanaLicenseAssociation#license_type}
    */
    readonly licenseType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_license_association#workspace_id GrafanaLicenseAssociation#workspace_id}
    */
    readonly workspaceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_license_association#timeouts GrafanaLicenseAssociation#timeouts}
    */
    readonly timeouts?: GrafanaLicenseAssociationTimeouts;
}
export interface GrafanaLicenseAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_license_association#create GrafanaLicenseAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_license_association#delete GrafanaLicenseAssociation#delete}
    */
    readonly delete?: string;
}
export declare function grafanaLicenseAssociationTimeoutsToTerraform(struct?: GrafanaLicenseAssociationTimeoutsOutputReference | GrafanaLicenseAssociationTimeouts | cdktf.IResolvable): any;
export declare class GrafanaLicenseAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrafanaLicenseAssociationTimeouts | undefined;
    set internalValue(value: GrafanaLicenseAssociationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/grafana_license_association aws_grafana_license_association}
*/
export declare class GrafanaLicenseAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_grafana_license_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/grafana_license_association aws_grafana_license_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GrafanaLicenseAssociationConfig
    */
    constructor(scope: Construct, id: string, config: GrafanaLicenseAssociationConfig);
    get freeTrialExpiration(): string;
    get id(): string;
    get licenseExpiration(): string;
    private _licenseType?;
    get licenseType(): string;
    set licenseType(value: string);
    get licenseTypeInput(): string | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): GrafanaLicenseAssociationTimeoutsOutputReference;
    putTimeouts(value: GrafanaLicenseAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): GrafanaLicenseAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=grafana-license-association.d.ts.map