import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GrafanaWorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_workspace#account_access_type GrafanaWorkspace#account_access_type}
    */
    readonly accountAccessType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_workspace#authentication_providers GrafanaWorkspace#authentication_providers}
    */
    readonly authenticationProviders: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_workspace#data_sources GrafanaWorkspace#data_sources}
    */
    readonly dataSources?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_workspace#description GrafanaWorkspace#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_workspace#name GrafanaWorkspace#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_workspace#notification_destinations GrafanaWorkspace#notification_destinations}
    */
    readonly notificationDestinations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_workspace#organization_role_name GrafanaWorkspace#organization_role_name}
    */
    readonly organizationRoleName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_workspace#organizational_units GrafanaWorkspace#organizational_units}
    */
    readonly organizationalUnits?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_workspace#permission_type GrafanaWorkspace#permission_type}
    */
    readonly permissionType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_workspace#role_arn GrafanaWorkspace#role_arn}
    */
    readonly roleArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_workspace#stack_set_name GrafanaWorkspace#stack_set_name}
    */
    readonly stackSetName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_workspace#tags GrafanaWorkspace#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_workspace#tags_all GrafanaWorkspace#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_workspace#timeouts GrafanaWorkspace#timeouts}
    */
    readonly timeouts?: GrafanaWorkspaceTimeouts;
}
export interface GrafanaWorkspaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_workspace#create GrafanaWorkspace#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/grafana_workspace#update GrafanaWorkspace#update}
    */
    readonly update?: string;
}
export declare function grafanaWorkspaceTimeoutsToTerraform(struct?: GrafanaWorkspaceTimeoutsOutputReference | GrafanaWorkspaceTimeouts | cdktf.IResolvable): any;
export declare class GrafanaWorkspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GrafanaWorkspaceTimeouts | undefined;
    set internalValue(value: GrafanaWorkspaceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/grafana_workspace aws_grafana_workspace}
*/
export declare class GrafanaWorkspace extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_grafana_workspace";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/grafana_workspace aws_grafana_workspace} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GrafanaWorkspaceConfig
    */
    constructor(scope: Construct, id: string, config: GrafanaWorkspaceConfig);
    private _accountAccessType?;
    get accountAccessType(): string;
    set accountAccessType(value: string);
    get accountAccessTypeInput(): string | undefined;
    get arn(): string;
    private _authenticationProviders?;
    get authenticationProviders(): string[];
    set authenticationProviders(value: string[]);
    get authenticationProvidersInput(): string[] | undefined;
    private _dataSources?;
    get dataSources(): string[];
    set dataSources(value: string[]);
    resetDataSources(): void;
    get dataSourcesInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get endpoint(): string;
    get grafanaVersion(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _notificationDestinations?;
    get notificationDestinations(): string[];
    set notificationDestinations(value: string[]);
    resetNotificationDestinations(): void;
    get notificationDestinationsInput(): string[] | undefined;
    private _organizationRoleName?;
    get organizationRoleName(): string;
    set organizationRoleName(value: string);
    resetOrganizationRoleName(): void;
    get organizationRoleNameInput(): string | undefined;
    private _organizationalUnits?;
    get organizationalUnits(): string[];
    set organizationalUnits(value: string[]);
    resetOrganizationalUnits(): void;
    get organizationalUnitsInput(): string[] | undefined;
    private _permissionType?;
    get permissionType(): string;
    set permissionType(value: string);
    get permissionTypeInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    resetRoleArn(): void;
    get roleArnInput(): string | undefined;
    get samlConfigurationStatus(): string;
    private _stackSetName?;
    get stackSetName(): string;
    set stackSetName(value: string);
    resetStackSetName(): void;
    get stackSetNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): GrafanaWorkspaceTimeoutsOutputReference;
    putTimeouts(value: GrafanaWorkspaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): GrafanaWorkspaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=grafana-workspace.d.ts.map