import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Identity and Access Management
*/
export interface DataAwsIamGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/iam_group#group_name DataAwsIamGroup#group_name}
    */
    readonly groupName: string;
}
export interface DataAwsIamGroupUsers {
}
export declare function dataAwsIamGroupUsersToTerraform(struct?: DataAwsIamGroupUsers): any;
export declare class DataAwsIamGroupUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsIamGroupUsers | undefined;
    set internalValue(value: DataAwsIamGroupUsers | undefined);
    get arn(): string;
    get path(): string;
    get userId(): string;
    get userName(): string;
}
export declare class DataAwsIamGroupUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsIamGroupUsersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/iam_group aws_iam_group}
*/
export declare class DataAwsIamGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_iam_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/iam_group aws_iam_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsIamGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsIamGroupConfig);
    get arn(): string;
    get groupId(): string;
    private _groupName?;
    get groupName(): string;
    set groupName(value: string);
    get groupNameInput(): string | undefined;
    get id(): string;
    get path(): string;
    private _users;
    get users(): DataAwsIamGroupUsersList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-iam-group.d.ts.map