import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Identity and Access Management
*/
export interface DataAwsIamInstanceProfilesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/iam_instance_profiles#role_name DataAwsIamInstanceProfiles#role_name}
    */
    readonly roleName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/iam_instance_profiles aws_iam_instance_profiles}
*/
export declare class DataAwsIamInstanceProfiles extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_iam_instance_profiles";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/iam_instance_profiles aws_iam_instance_profiles} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsIamInstanceProfilesConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsIamInstanceProfilesConfig);
    get arns(): string[];
    get id(): string;
    get names(): string[];
    get paths(): string[];
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-iam-instance-profiles.d.ts.map