import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Identity and Access Management
*/
export interface IamUserLoginProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iam_user_login_profile#password_length IamUserLoginProfile#password_length}
    */
    readonly passwordLength?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iam_user_login_profile#password_reset_required IamUserLoginProfile#password_reset_required}
    */
    readonly passwordResetRequired?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iam_user_login_profile#pgp_key IamUserLoginProfile#pgp_key}
    */
    readonly pgpKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iam_user_login_profile#user IamUserLoginProfile#user}
    */
    readonly user: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/iam_user_login_profile aws_iam_user_login_profile}
*/
export declare class IamUserLoginProfile extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_iam_user_login_profile";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/iam_user_login_profile aws_iam_user_login_profile} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IamUserLoginProfileConfig
    */
    constructor(scope: Construct, id: string, config: IamUserLoginProfileConfig);
    get encryptedPassword(): string;
    get id(): string;
    get keyFingerprint(): string;
    get password(): string;
    private _passwordLength?;
    get passwordLength(): number;
    set passwordLength(value: number);
    resetPasswordLength(): void;
    get passwordLengthInput(): number | undefined;
    private _passwordResetRequired?;
    get passwordResetRequired(): boolean | cdktf.IResolvable;
    set passwordResetRequired(value: boolean | cdktf.IResolvable);
    resetPasswordResetRequired(): void;
    get passwordResetRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _pgpKey?;
    get pgpKey(): string;
    set pgpKey(value: string);
    resetPgpKey(): void;
    get pgpKeyInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    get userInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=iam-user-login-profile.d.ts.map