import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Image Builder
*/
export interface DataAwsImagebuilderContainerRecipesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_container_recipes#owner DataAwsImagebuilderContainerRecipes#owner}
    */
    readonly owner?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_container_recipes#filter DataAwsImagebuilderContainerRecipes#filter}
    */
    readonly filter?: DataAwsImagebuilderContainerRecipesFilter[] | cdktf.IResolvable;
}
export interface DataAwsImagebuilderContainerRecipesFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_container_recipes#name DataAwsImagebuilderContainerRecipes#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_container_recipes#values DataAwsImagebuilderContainerRecipes#values}
    */
    readonly values: string[];
}
export declare function dataAwsImagebuilderContainerRecipesFilterToTerraform(struct?: DataAwsImagebuilderContainerRecipesFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_container_recipes aws_imagebuilder_container_recipes}
*/
export declare class DataAwsImagebuilderContainerRecipes extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_imagebuilder_container_recipes";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_container_recipes aws_imagebuilder_container_recipes} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsImagebuilderContainerRecipesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsImagebuilderContainerRecipesConfig);
    get arns(): string[];
    get id(): string;
    get names(): string[];
    private _owner?;
    get owner(): string;
    set owner(value: string);
    resetOwner(): void;
    get ownerInput(): string | undefined;
    private _filter?;
    get filter(): DataAwsImagebuilderContainerRecipesFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsImagebuilderContainerRecipesFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsImagebuilderContainerRecipesFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-imagebuilder-container-recipes.d.ts.map