import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Image Builder
*/
export interface DataAwsImagebuilderDistributionConfigurationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_distribution_configurations#filter DataAwsImagebuilderDistributionConfigurations#filter}
    */
    readonly filter?: DataAwsImagebuilderDistributionConfigurationsFilter[] | cdktf.IResolvable;
}
export interface DataAwsImagebuilderDistributionConfigurationsFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_distribution_configurations#name DataAwsImagebuilderDistributionConfigurations#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_distribution_configurations#values DataAwsImagebuilderDistributionConfigurations#values}
    */
    readonly values: string[];
}
export declare function dataAwsImagebuilderDistributionConfigurationsFilterToTerraform(struct?: DataAwsImagebuilderDistributionConfigurationsFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_distribution_configurations aws_imagebuilder_distribution_configurations}
*/
export declare class DataAwsImagebuilderDistributionConfigurations extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_imagebuilder_distribution_configurations";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_distribution_configurations aws_imagebuilder_distribution_configurations} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsImagebuilderDistributionConfigurationsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsImagebuilderDistributionConfigurationsConfig);
    get arns(): string[];
    get id(): string;
    get names(): string[];
    private _filter?;
    get filter(): DataAwsImagebuilderDistributionConfigurationsFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsImagebuilderDistributionConfigurationsFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsImagebuilderDistributionConfigurationsFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-imagebuilder-distribution-configurations.d.ts.map