import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Image Builder
*/
export interface DataAwsImagebuilderImagePipelineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_image_pipeline#arn DataAwsImagebuilderImagePipeline#arn}
    */
    readonly arn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_image_pipeline#tags DataAwsImagebuilderImagePipeline#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataAwsImagebuilderImagePipelineImageTestsConfiguration {
}
export declare function dataAwsImagebuilderImagePipelineImageTestsConfigurationToTerraform(struct?: DataAwsImagebuilderImagePipelineImageTestsConfiguration): any;
export declare class DataAwsImagebuilderImagePipelineImageTestsConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsImagebuilderImagePipelineImageTestsConfiguration | undefined;
    set internalValue(value: DataAwsImagebuilderImagePipelineImageTestsConfiguration | undefined);
    get imageTestsEnabled(): cdktf.IResolvable;
    get timeoutMinutes(): number;
}
export declare class DataAwsImagebuilderImagePipelineImageTestsConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsImagebuilderImagePipelineImageTestsConfigurationOutputReference;
}
export interface DataAwsImagebuilderImagePipelineSchedule {
}
export declare function dataAwsImagebuilderImagePipelineScheduleToTerraform(struct?: DataAwsImagebuilderImagePipelineSchedule): any;
export declare class DataAwsImagebuilderImagePipelineScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsImagebuilderImagePipelineSchedule | undefined;
    set internalValue(value: DataAwsImagebuilderImagePipelineSchedule | undefined);
    get pipelineExecutionStartCondition(): string;
    get scheduleExpression(): string;
}
export declare class DataAwsImagebuilderImagePipelineScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsImagebuilderImagePipelineScheduleOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_image_pipeline aws_imagebuilder_image_pipeline}
*/
export declare class DataAwsImagebuilderImagePipeline extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_imagebuilder_image_pipeline";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_image_pipeline aws_imagebuilder_image_pipeline} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsImagebuilderImagePipelineConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsImagebuilderImagePipelineConfig);
    private _arn?;
    get arn(): string;
    set arn(value: string);
    get arnInput(): string | undefined;
    get containerRecipeArn(): string;
    get dateCreated(): string;
    get dateLastRun(): string;
    get dateNextRun(): string;
    get dateUpdated(): string;
    get description(): string;
    get distributionConfigurationArn(): string;
    get enhancedImageMetadataEnabled(): cdktf.IResolvable;
    get id(): string;
    get imageRecipeArn(): string;
    private _imageTestsConfiguration;
    get imageTestsConfiguration(): DataAwsImagebuilderImagePipelineImageTestsConfigurationList;
    get infrastructureConfigurationArn(): string;
    get name(): string;
    get platform(): string;
    private _schedule;
    get schedule(): DataAwsImagebuilderImagePipelineScheduleList;
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-imagebuilder-image-pipeline.d.ts.map