import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Image Builder
*/
export interface DataAwsImagebuilderImagePipelinesConfig extends cdktf.TerraformMetaArguments {
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_image_pipelines#filter DataAwsImagebuilderImagePipelines#filter}
    */
    readonly filter?: DataAwsImagebuilderImagePipelinesFilter[] | cdktf.IResolvable;
}
export interface DataAwsImagebuilderImagePipelinesFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_image_pipelines#name DataAwsImagebuilderImagePipelines#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_image_pipelines#values DataAwsImagebuilderImagePipelines#values}
    */
    readonly values: string[];
}
export declare function dataAwsImagebuilderImagePipelinesFilterToTerraform(struct?: DataAwsImagebuilderImagePipelinesFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_image_pipelines aws_imagebuilder_image_pipelines}
*/
export declare class DataAwsImagebuilderImagePipelines extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_imagebuilder_image_pipelines";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_image_pipelines aws_imagebuilder_image_pipelines} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsImagebuilderImagePipelinesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsImagebuilderImagePipelinesConfig);
    get arns(): string[];
    get id(): string;
    get names(): string[];
    private _filter?;
    get filter(): DataAwsImagebuilderImagePipelinesFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsImagebuilderImagePipelinesFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsImagebuilderImagePipelinesFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-imagebuilder-image-pipelines.d.ts.map