import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Image Builder
*/
export interface DataAwsImagebuilderInfrastructureConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_infrastructure_configuration#arn DataAwsImagebuilderInfrastructureConfiguration#arn}
    */
    readonly arn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_infrastructure_configuration#resource_tags DataAwsImagebuilderInfrastructureConfiguration#resource_tags}
    */
    readonly resourceTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_infrastructure_configuration#tags DataAwsImagebuilderInfrastructureConfiguration#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataAwsImagebuilderInfrastructureConfigurationInstanceMetadataOptions {
}
export declare function dataAwsImagebuilderInfrastructureConfigurationInstanceMetadataOptionsToTerraform(struct?: DataAwsImagebuilderInfrastructureConfigurationInstanceMetadataOptions): any;
export declare class DataAwsImagebuilderInfrastructureConfigurationInstanceMetadataOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsImagebuilderInfrastructureConfigurationInstanceMetadataOptions | undefined;
    set internalValue(value: DataAwsImagebuilderInfrastructureConfigurationInstanceMetadataOptions | undefined);
    get httpPutResponseHopLimit(): number;
    get httpTokens(): string;
}
export declare class DataAwsImagebuilderInfrastructureConfigurationInstanceMetadataOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsImagebuilderInfrastructureConfigurationInstanceMetadataOptionsOutputReference;
}
export interface DataAwsImagebuilderInfrastructureConfigurationLoggingS3Logs {
}
export declare function dataAwsImagebuilderInfrastructureConfigurationLoggingS3LogsToTerraform(struct?: DataAwsImagebuilderInfrastructureConfigurationLoggingS3Logs): any;
export declare class DataAwsImagebuilderInfrastructureConfigurationLoggingS3LogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsImagebuilderInfrastructureConfigurationLoggingS3Logs | undefined;
    set internalValue(value: DataAwsImagebuilderInfrastructureConfigurationLoggingS3Logs | undefined);
    get s3BucketName(): string;
    get s3KeyPrefix(): string;
}
export declare class DataAwsImagebuilderInfrastructureConfigurationLoggingS3LogsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsImagebuilderInfrastructureConfigurationLoggingS3LogsOutputReference;
}
export interface DataAwsImagebuilderInfrastructureConfigurationLogging {
}
export declare function dataAwsImagebuilderInfrastructureConfigurationLoggingToTerraform(struct?: DataAwsImagebuilderInfrastructureConfigurationLogging): any;
export declare class DataAwsImagebuilderInfrastructureConfigurationLoggingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsImagebuilderInfrastructureConfigurationLogging | undefined;
    set internalValue(value: DataAwsImagebuilderInfrastructureConfigurationLogging | undefined);
    private _s3Logs;
    get s3Logs(): DataAwsImagebuilderInfrastructureConfigurationLoggingS3LogsList;
}
export declare class DataAwsImagebuilderInfrastructureConfigurationLoggingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsImagebuilderInfrastructureConfigurationLoggingOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_infrastructure_configuration aws_imagebuilder_infrastructure_configuration}
*/
export declare class DataAwsImagebuilderInfrastructureConfiguration extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_imagebuilder_infrastructure_configuration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_infrastructure_configuration aws_imagebuilder_infrastructure_configuration} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsImagebuilderInfrastructureConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsImagebuilderInfrastructureConfigurationConfig);
    private _arn?;
    get arn(): string;
    set arn(value: string);
    get arnInput(): string | undefined;
    get dateCreated(): string;
    get dateUpdated(): string;
    get description(): string;
    get id(): string;
    private _instanceMetadataOptions;
    get instanceMetadataOptions(): DataAwsImagebuilderInfrastructureConfigurationInstanceMetadataOptionsList;
    get instanceProfileName(): string;
    get instanceTypes(): string[];
    get keyPair(): string;
    private _logging;
    get logging(): DataAwsImagebuilderInfrastructureConfigurationLoggingList;
    get name(): string;
    private _resourceTags?;
    get resourceTags(): {
        [key: string]: string;
    };
    set resourceTags(value: {
        [key: string]: string;
    });
    resetResourceTags(): void;
    get resourceTagsInput(): {
        [key: string]: string;
    } | undefined;
    get securityGroupIds(): string[];
    get snsTopicArn(): string;
    get subnetId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get terminateInstanceOnFailure(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-imagebuilder-infrastructure-configuration.d.ts.map