import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Image Builder
*/
export interface DataAwsImagebuilderInfrastructureConfigurationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_infrastructure_configurations#filter DataAwsImagebuilderInfrastructureConfigurations#filter}
    */
    readonly filter?: DataAwsImagebuilderInfrastructureConfigurationsFilter[] | cdktf.IResolvable;
}
export interface DataAwsImagebuilderInfrastructureConfigurationsFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_infrastructure_configurations#name DataAwsImagebuilderInfrastructureConfigurations#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_infrastructure_configurations#values DataAwsImagebuilderInfrastructureConfigurations#values}
    */
    readonly values: string[];
}
export declare function dataAwsImagebuilderInfrastructureConfigurationsFilterToTerraform(struct?: DataAwsImagebuilderInfrastructureConfigurationsFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_infrastructure_configurations aws_imagebuilder_infrastructure_configurations}
*/
export declare class DataAwsImagebuilderInfrastructureConfigurations extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_imagebuilder_infrastructure_configurations";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/imagebuilder_infrastructure_configurations aws_imagebuilder_infrastructure_configurations} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsImagebuilderInfrastructureConfigurationsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsImagebuilderInfrastructureConfigurationsConfig);
    get arns(): string[];
    get id(): string;
    get names(): string[];
    private _filter?;
    get filter(): DataAwsImagebuilderInfrastructureConfigurationsFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsImagebuilderInfrastructureConfigurationsFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsImagebuilderInfrastructureConfigurationsFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-imagebuilder-infrastructure-configurations.d.ts.map