import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Inspector
*/
export interface InspectorAssessmentTargetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/inspector_assessment_target#name InspectorAssessmentTarget#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/inspector_assessment_target#resource_group_arn InspectorAssessmentTarget#resource_group_arn}
    */
    readonly resourceGroupArn?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/inspector_assessment_target aws_inspector_assessment_target}
*/
export declare class InspectorAssessmentTarget extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_inspector_assessment_target";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/inspector_assessment_target aws_inspector_assessment_target} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options InspectorAssessmentTargetConfig
    */
    constructor(scope: Construct, id: string, config: InspectorAssessmentTargetConfig);
    get arn(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupArn?;
    get resourceGroupArn(): string;
    set resourceGroupArn(value: string);
    resetResourceGroupArn(): void;
    get resourceGroupArnInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=inspector-assessment-target.d.ts.map