import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS IoT
*/
export interface IotAuthorizerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_authorizer#authorizer_function_arn IotAuthorizer#authorizer_function_arn}
    */
    readonly authorizerFunctionArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_authorizer#enable_caching_for_http IotAuthorizer#enable_caching_for_http}
    */
    readonly enableCachingForHttp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_authorizer#name IotAuthorizer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_authorizer#signing_disabled IotAuthorizer#signing_disabled}
    */
    readonly signingDisabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_authorizer#status IotAuthorizer#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_authorizer#token_key_name IotAuthorizer#token_key_name}
    */
    readonly tokenKeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_authorizer#token_signing_public_keys IotAuthorizer#token_signing_public_keys}
    */
    readonly tokenSigningPublicKeys?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/iot_authorizer aws_iot_authorizer}
*/
export declare class IotAuthorizer extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_iot_authorizer";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/iot_authorizer aws_iot_authorizer} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IotAuthorizerConfig
    */
    constructor(scope: Construct, id: string, config: IotAuthorizerConfig);
    get arn(): string;
    private _authorizerFunctionArn?;
    get authorizerFunctionArn(): string;
    set authorizerFunctionArn(value: string);
    get authorizerFunctionArnInput(): string | undefined;
    private _enableCachingForHttp?;
    get enableCachingForHttp(): boolean | cdktf.IResolvable;
    set enableCachingForHttp(value: boolean | cdktf.IResolvable);
    resetEnableCachingForHttp(): void;
    get enableCachingForHttpInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _signingDisabled?;
    get signingDisabled(): boolean | cdktf.IResolvable;
    set signingDisabled(value: boolean | cdktf.IResolvable);
    resetSigningDisabled(): void;
    get signingDisabledInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _tokenKeyName?;
    get tokenKeyName(): string;
    set tokenKeyName(value: string);
    resetTokenKeyName(): void;
    get tokenKeyNameInput(): string | undefined;
    private _tokenSigningPublicKeys?;
    get tokenSigningPublicKeys(): {
        [key: string]: string;
    };
    set tokenSigningPublicKeys(value: {
        [key: string]: string;
    });
    resetTokenSigningPublicKeys(): void;
    get tokenSigningPublicKeysInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=iot-authorizer.d.ts.map