import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS IoT
*/
export interface IotIndexingConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * thing_group_indexing_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#thing_group_indexing_configuration IotIndexingConfiguration#thing_group_indexing_configuration}
    */
    readonly thingGroupIndexingConfiguration?: IotIndexingConfigurationThingGroupIndexingConfiguration;
    /**
    * thing_indexing_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#thing_indexing_configuration IotIndexingConfiguration#thing_indexing_configuration}
    */
    readonly thingIndexingConfiguration?: IotIndexingConfigurationThingIndexingConfiguration;
}
export interface IotIndexingConfigurationThingGroupIndexingConfigurationCustomField {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#name IotIndexingConfiguration#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#type IotIndexingConfiguration#type}
    */
    readonly type?: string;
}
export declare function iotIndexingConfigurationThingGroupIndexingConfigurationCustomFieldToTerraform(struct?: IotIndexingConfigurationThingGroupIndexingConfigurationCustomField | cdktf.IResolvable): any;
export interface IotIndexingConfigurationThingGroupIndexingConfigurationManagedField {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#name IotIndexingConfiguration#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#type IotIndexingConfiguration#type}
    */
    readonly type?: string;
}
export declare function iotIndexingConfigurationThingGroupIndexingConfigurationManagedFieldToTerraform(struct?: IotIndexingConfigurationThingGroupIndexingConfigurationManagedField | cdktf.IResolvable): any;
export interface IotIndexingConfigurationThingGroupIndexingConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#thing_group_indexing_mode IotIndexingConfiguration#thing_group_indexing_mode}
    */
    readonly thingGroupIndexingMode: string;
    /**
    * custom_field block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#custom_field IotIndexingConfiguration#custom_field}
    */
    readonly customField?: IotIndexingConfigurationThingGroupIndexingConfigurationCustomField[] | cdktf.IResolvable;
    /**
    * managed_field block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#managed_field IotIndexingConfiguration#managed_field}
    */
    readonly managedField?: IotIndexingConfigurationThingGroupIndexingConfigurationManagedField[] | cdktf.IResolvable;
}
export declare function iotIndexingConfigurationThingGroupIndexingConfigurationToTerraform(struct?: IotIndexingConfigurationThingGroupIndexingConfigurationOutputReference | IotIndexingConfigurationThingGroupIndexingConfiguration): any;
export declare class IotIndexingConfigurationThingGroupIndexingConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotIndexingConfigurationThingGroupIndexingConfiguration | undefined;
    set internalValue(value: IotIndexingConfigurationThingGroupIndexingConfiguration | undefined);
    private _thingGroupIndexingMode?;
    get thingGroupIndexingMode(): string;
    set thingGroupIndexingMode(value: string);
    get thingGroupIndexingModeInput(): string | undefined;
    private _customField?;
    get customField(): IotIndexingConfigurationThingGroupIndexingConfigurationCustomField[] | cdktf.IResolvable;
    set customField(value: IotIndexingConfigurationThingGroupIndexingConfigurationCustomField[] | cdktf.IResolvable);
    resetCustomField(): void;
    get customFieldInput(): cdktf.IResolvable | IotIndexingConfigurationThingGroupIndexingConfigurationCustomField[] | undefined;
    private _managedField?;
    get managedField(): IotIndexingConfigurationThingGroupIndexingConfigurationManagedField[] | cdktf.IResolvable;
    set managedField(value: IotIndexingConfigurationThingGroupIndexingConfigurationManagedField[] | cdktf.IResolvable);
    resetManagedField(): void;
    get managedFieldInput(): cdktf.IResolvable | IotIndexingConfigurationThingGroupIndexingConfigurationManagedField[] | undefined;
}
export interface IotIndexingConfigurationThingIndexingConfigurationCustomField {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#name IotIndexingConfiguration#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#type IotIndexingConfiguration#type}
    */
    readonly type?: string;
}
export declare function iotIndexingConfigurationThingIndexingConfigurationCustomFieldToTerraform(struct?: IotIndexingConfigurationThingIndexingConfigurationCustomField | cdktf.IResolvable): any;
export interface IotIndexingConfigurationThingIndexingConfigurationManagedField {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#name IotIndexingConfiguration#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#type IotIndexingConfiguration#type}
    */
    readonly type?: string;
}
export declare function iotIndexingConfigurationThingIndexingConfigurationManagedFieldToTerraform(struct?: IotIndexingConfigurationThingIndexingConfigurationManagedField | cdktf.IResolvable): any;
export interface IotIndexingConfigurationThingIndexingConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#device_defender_indexing_mode IotIndexingConfiguration#device_defender_indexing_mode}
    */
    readonly deviceDefenderIndexingMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#named_shadow_indexing_mode IotIndexingConfiguration#named_shadow_indexing_mode}
    */
    readonly namedShadowIndexingMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#thing_connectivity_indexing_mode IotIndexingConfiguration#thing_connectivity_indexing_mode}
    */
    readonly thingConnectivityIndexingMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#thing_indexing_mode IotIndexingConfiguration#thing_indexing_mode}
    */
    readonly thingIndexingMode: string;
    /**
    * custom_field block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#custom_field IotIndexingConfiguration#custom_field}
    */
    readonly customField?: IotIndexingConfigurationThingIndexingConfigurationCustomField[] | cdktf.IResolvable;
    /**
    * managed_field block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration#managed_field IotIndexingConfiguration#managed_field}
    */
    readonly managedField?: IotIndexingConfigurationThingIndexingConfigurationManagedField[] | cdktf.IResolvable;
}
export declare function iotIndexingConfigurationThingIndexingConfigurationToTerraform(struct?: IotIndexingConfigurationThingIndexingConfigurationOutputReference | IotIndexingConfigurationThingIndexingConfiguration): any;
export declare class IotIndexingConfigurationThingIndexingConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotIndexingConfigurationThingIndexingConfiguration | undefined;
    set internalValue(value: IotIndexingConfigurationThingIndexingConfiguration | undefined);
    private _deviceDefenderIndexingMode?;
    get deviceDefenderIndexingMode(): string;
    set deviceDefenderIndexingMode(value: string);
    resetDeviceDefenderIndexingMode(): void;
    get deviceDefenderIndexingModeInput(): string | undefined;
    private _namedShadowIndexingMode?;
    get namedShadowIndexingMode(): string;
    set namedShadowIndexingMode(value: string);
    resetNamedShadowIndexingMode(): void;
    get namedShadowIndexingModeInput(): string | undefined;
    private _thingConnectivityIndexingMode?;
    get thingConnectivityIndexingMode(): string;
    set thingConnectivityIndexingMode(value: string);
    resetThingConnectivityIndexingMode(): void;
    get thingConnectivityIndexingModeInput(): string | undefined;
    private _thingIndexingMode?;
    get thingIndexingMode(): string;
    set thingIndexingMode(value: string);
    get thingIndexingModeInput(): string | undefined;
    private _customField?;
    get customField(): IotIndexingConfigurationThingIndexingConfigurationCustomField[] | cdktf.IResolvable;
    set customField(value: IotIndexingConfigurationThingIndexingConfigurationCustomField[] | cdktf.IResolvable);
    resetCustomField(): void;
    get customFieldInput(): cdktf.IResolvable | IotIndexingConfigurationThingIndexingConfigurationCustomField[] | undefined;
    private _managedField?;
    get managedField(): IotIndexingConfigurationThingIndexingConfigurationManagedField[] | cdktf.IResolvable;
    set managedField(value: IotIndexingConfigurationThingIndexingConfigurationManagedField[] | cdktf.IResolvable);
    resetManagedField(): void;
    get managedFieldInput(): cdktf.IResolvable | IotIndexingConfigurationThingIndexingConfigurationManagedField[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration aws_iot_indexing_configuration}
*/
export declare class IotIndexingConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_iot_indexing_configuration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/iot_indexing_configuration aws_iot_indexing_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IotIndexingConfigurationConfig = {}
    */
    constructor(scope: Construct, id: string, config?: IotIndexingConfigurationConfig);
    get id(): string;
    private _thingGroupIndexingConfiguration;
    get thingGroupIndexingConfiguration(): IotIndexingConfigurationThingGroupIndexingConfigurationOutputReference;
    putThingGroupIndexingConfiguration(value: IotIndexingConfigurationThingGroupIndexingConfiguration): void;
    resetThingGroupIndexingConfiguration(): void;
    get thingGroupIndexingConfigurationInput(): IotIndexingConfigurationThingGroupIndexingConfiguration | undefined;
    private _thingIndexingConfiguration;
    get thingIndexingConfiguration(): IotIndexingConfigurationThingIndexingConfigurationOutputReference;
    putThingIndexingConfiguration(value: IotIndexingConfigurationThingIndexingConfiguration): void;
    resetThingIndexingConfiguration(): void;
    get thingIndexingConfigurationInput(): IotIndexingConfigurationThingIndexingConfiguration | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=iot-indexing-configuration.d.ts.map