import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS IoT
*/
export interface IotLoggingOptionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_logging_options#default_log_level IotLoggingOptions#default_log_level}
    */
    readonly defaultLogLevel: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_logging_options#disable_all_logs IotLoggingOptions#disable_all_logs}
    */
    readonly disableAllLogs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_logging_options#role_arn IotLoggingOptions#role_arn}
    */
    readonly roleArn: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/iot_logging_options aws_iot_logging_options}
*/
export declare class IotLoggingOptions extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_iot_logging_options";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/iot_logging_options aws_iot_logging_options} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IotLoggingOptionsConfig
    */
    constructor(scope: Construct, id: string, config: IotLoggingOptionsConfig);
    private _defaultLogLevel?;
    get defaultLogLevel(): string;
    set defaultLogLevel(value: string);
    get defaultLogLevelInput(): string | undefined;
    private _disableAllLogs?;
    get disableAllLogs(): boolean | cdktf.IResolvable;
    set disableAllLogs(value: boolean | cdktf.IResolvable);
    resetDisableAllLogs(): void;
    get disableAllLogsInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=iot-logging-options.d.ts.map