import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS IoT
*/
export interface IotTopicRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#description IotTopicRule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#enabled IotTopicRule#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#name IotTopicRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#sql IotTopicRule#sql}
    */
    readonly sql: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#sql_version IotTopicRule#sql_version}
    */
    readonly sqlVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#tags IotTopicRule#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#tags_all IotTopicRule#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * cloudwatch_alarm block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#cloudwatch_alarm IotTopicRule#cloudwatch_alarm}
    */
    readonly cloudwatchAlarm?: IotTopicRuleCloudwatchAlarm[] | cdktf.IResolvable;
    /**
    * cloudwatch_logs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#cloudwatch_logs IotTopicRule#cloudwatch_logs}
    */
    readonly cloudwatchLogs?: IotTopicRuleCloudwatchLogs[] | cdktf.IResolvable;
    /**
    * cloudwatch_metric block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#cloudwatch_metric IotTopicRule#cloudwatch_metric}
    */
    readonly cloudwatchMetric?: IotTopicRuleCloudwatchMetric[] | cdktf.IResolvable;
    /**
    * dynamodb block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#dynamodb IotTopicRule#dynamodb}
    */
    readonly dynamodb?: IotTopicRuleDynamodb[] | cdktf.IResolvable;
    /**
    * dynamodbv2 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#dynamodbv2 IotTopicRule#dynamodbv2}
    */
    readonly dynamodbv2?: IotTopicRuleDynamodbv2[] | cdktf.IResolvable;
    /**
    * elasticsearch block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#elasticsearch IotTopicRule#elasticsearch}
    */
    readonly elasticsearch?: IotTopicRuleElasticsearch[] | cdktf.IResolvable;
    /**
    * error_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#error_action IotTopicRule#error_action}
    */
    readonly errorAction?: IotTopicRuleErrorAction;
    /**
    * firehose block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#firehose IotTopicRule#firehose}
    */
    readonly firehose?: IotTopicRuleFirehose[] | cdktf.IResolvable;
    /**
    * http block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#http IotTopicRule#http}
    */
    readonly http?: IotTopicRuleHttp[] | cdktf.IResolvable;
    /**
    * iot_analytics block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#iot_analytics IotTopicRule#iot_analytics}
    */
    readonly iotAnalytics?: IotTopicRuleIotAnalytics[] | cdktf.IResolvable;
    /**
    * iot_events block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#iot_events IotTopicRule#iot_events}
    */
    readonly iotEvents?: IotTopicRuleIotEvents[] | cdktf.IResolvable;
    /**
    * kafka block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#kafka IotTopicRule#kafka}
    */
    readonly kafka?: IotTopicRuleKafka[] | cdktf.IResolvable;
    /**
    * kinesis block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#kinesis IotTopicRule#kinesis}
    */
    readonly kinesis?: IotTopicRuleKinesis[] | cdktf.IResolvable;
    /**
    * lambda block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#lambda IotTopicRule#lambda}
    */
    readonly lambda?: IotTopicRuleLambda[] | cdktf.IResolvable;
    /**
    * republish block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#republish IotTopicRule#republish}
    */
    readonly republish?: IotTopicRuleRepublish[] | cdktf.IResolvable;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#s3 IotTopicRule#s3}
    */
    readonly s3?: IotTopicRuleS3[] | cdktf.IResolvable;
    /**
    * sns block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#sns IotTopicRule#sns}
    */
    readonly sns?: IotTopicRuleSns[] | cdktf.IResolvable;
    /**
    * sqs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#sqs IotTopicRule#sqs}
    */
    readonly sqs?: IotTopicRuleSqs[] | cdktf.IResolvable;
    /**
    * step_functions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#step_functions IotTopicRule#step_functions}
    */
    readonly stepFunctions?: IotTopicRuleStepFunctions[] | cdktf.IResolvable;
    /**
    * timestream block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#timestream IotTopicRule#timestream}
    */
    readonly timestream?: IotTopicRuleTimestream[] | cdktf.IResolvable;
}
export interface IotTopicRuleCloudwatchAlarm {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#alarm_name IotTopicRule#alarm_name}
    */
    readonly alarmName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#state_reason IotTopicRule#state_reason}
    */
    readonly stateReason: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#state_value IotTopicRule#state_value}
    */
    readonly stateValue: string;
}
export declare function iotTopicRuleCloudwatchAlarmToTerraform(struct?: IotTopicRuleCloudwatchAlarm | cdktf.IResolvable): any;
export interface IotTopicRuleCloudwatchLogs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#log_group_name IotTopicRule#log_group_name}
    */
    readonly logGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
}
export declare function iotTopicRuleCloudwatchLogsToTerraform(struct?: IotTopicRuleCloudwatchLogs | cdktf.IResolvable): any;
export interface IotTopicRuleCloudwatchMetric {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#metric_name IotTopicRule#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#metric_namespace IotTopicRule#metric_namespace}
    */
    readonly metricNamespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#metric_timestamp IotTopicRule#metric_timestamp}
    */
    readonly metricTimestamp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#metric_unit IotTopicRule#metric_unit}
    */
    readonly metricUnit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#metric_value IotTopicRule#metric_value}
    */
    readonly metricValue: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
}
export declare function iotTopicRuleCloudwatchMetricToTerraform(struct?: IotTopicRuleCloudwatchMetric | cdktf.IResolvable): any;
export interface IotTopicRuleDynamodb {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#hash_key_field IotTopicRule#hash_key_field}
    */
    readonly hashKeyField: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#hash_key_type IotTopicRule#hash_key_type}
    */
    readonly hashKeyType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#hash_key_value IotTopicRule#hash_key_value}
    */
    readonly hashKeyValue: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#operation IotTopicRule#operation}
    */
    readonly operation?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#payload_field IotTopicRule#payload_field}
    */
    readonly payloadField?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#range_key_field IotTopicRule#range_key_field}
    */
    readonly rangeKeyField?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#range_key_type IotTopicRule#range_key_type}
    */
    readonly rangeKeyType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#range_key_value IotTopicRule#range_key_value}
    */
    readonly rangeKeyValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#table_name IotTopicRule#table_name}
    */
    readonly tableName: string;
}
export declare function iotTopicRuleDynamodbToTerraform(struct?: IotTopicRuleDynamodb | cdktf.IResolvable): any;
export interface IotTopicRuleDynamodbv2PutItem {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#table_name IotTopicRule#table_name}
    */
    readonly tableName: string;
}
export declare function iotTopicRuleDynamodbv2PutItemToTerraform(struct?: IotTopicRuleDynamodbv2PutItemOutputReference | IotTopicRuleDynamodbv2PutItem): any;
export declare class IotTopicRuleDynamodbv2PutItemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleDynamodbv2PutItem | undefined;
    set internalValue(value: IotTopicRuleDynamodbv2PutItem | undefined);
    private _tableName?;
    get tableName(): string;
    set tableName(value: string);
    get tableNameInput(): string | undefined;
}
export interface IotTopicRuleDynamodbv2 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * put_item block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#put_item IotTopicRule#put_item}
    */
    readonly putItem?: IotTopicRuleDynamodbv2PutItem;
}
export declare function iotTopicRuleDynamodbv2ToTerraform(struct?: IotTopicRuleDynamodbv2 | cdktf.IResolvable): any;
export interface IotTopicRuleElasticsearch {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#endpoint IotTopicRule#endpoint}
    */
    readonly endpoint: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#id IotTopicRule#id}
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#index IotTopicRule#index}
    */
    readonly index: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#type IotTopicRule#type}
    */
    readonly type: string;
}
export declare function iotTopicRuleElasticsearchToTerraform(struct?: IotTopicRuleElasticsearch | cdktf.IResolvable): any;
export interface IotTopicRuleErrorActionCloudwatchAlarm {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#alarm_name IotTopicRule#alarm_name}
    */
    readonly alarmName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#state_reason IotTopicRule#state_reason}
    */
    readonly stateReason: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#state_value IotTopicRule#state_value}
    */
    readonly stateValue: string;
}
export declare function iotTopicRuleErrorActionCloudwatchAlarmToTerraform(struct?: IotTopicRuleErrorActionCloudwatchAlarmOutputReference | IotTopicRuleErrorActionCloudwatchAlarm): any;
export declare class IotTopicRuleErrorActionCloudwatchAlarmOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionCloudwatchAlarm | undefined;
    set internalValue(value: IotTopicRuleErrorActionCloudwatchAlarm | undefined);
    private _alarmName?;
    get alarmName(): string;
    set alarmName(value: string);
    get alarmNameInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
    private _stateReason?;
    get stateReason(): string;
    set stateReason(value: string);
    get stateReasonInput(): string | undefined;
    private _stateValue?;
    get stateValue(): string;
    set stateValue(value: string);
    get stateValueInput(): string | undefined;
}
export interface IotTopicRuleErrorActionCloudwatchLogs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#log_group_name IotTopicRule#log_group_name}
    */
    readonly logGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
}
export declare function iotTopicRuleErrorActionCloudwatchLogsToTerraform(struct?: IotTopicRuleErrorActionCloudwatchLogsOutputReference | IotTopicRuleErrorActionCloudwatchLogs): any;
export declare class IotTopicRuleErrorActionCloudwatchLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionCloudwatchLogs | undefined;
    set internalValue(value: IotTopicRuleErrorActionCloudwatchLogs | undefined);
    private _logGroupName?;
    get logGroupName(): string;
    set logGroupName(value: string);
    get logGroupNameInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
}
export interface IotTopicRuleErrorActionCloudwatchMetric {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#metric_name IotTopicRule#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#metric_namespace IotTopicRule#metric_namespace}
    */
    readonly metricNamespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#metric_timestamp IotTopicRule#metric_timestamp}
    */
    readonly metricTimestamp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#metric_unit IotTopicRule#metric_unit}
    */
    readonly metricUnit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#metric_value IotTopicRule#metric_value}
    */
    readonly metricValue: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
}
export declare function iotTopicRuleErrorActionCloudwatchMetricToTerraform(struct?: IotTopicRuleErrorActionCloudwatchMetricOutputReference | IotTopicRuleErrorActionCloudwatchMetric): any;
export declare class IotTopicRuleErrorActionCloudwatchMetricOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionCloudwatchMetric | undefined;
    set internalValue(value: IotTopicRuleErrorActionCloudwatchMetric | undefined);
    private _metricName?;
    get metricName(): string;
    set metricName(value: string);
    get metricNameInput(): string | undefined;
    private _metricNamespace?;
    get metricNamespace(): string;
    set metricNamespace(value: string);
    get metricNamespaceInput(): string | undefined;
    private _metricTimestamp?;
    get metricTimestamp(): string;
    set metricTimestamp(value: string);
    resetMetricTimestamp(): void;
    get metricTimestampInput(): string | undefined;
    private _metricUnit?;
    get metricUnit(): string;
    set metricUnit(value: string);
    get metricUnitInput(): string | undefined;
    private _metricValue?;
    get metricValue(): string;
    set metricValue(value: string);
    get metricValueInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
}
export interface IotTopicRuleErrorActionDynamodb {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#hash_key_field IotTopicRule#hash_key_field}
    */
    readonly hashKeyField: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#hash_key_type IotTopicRule#hash_key_type}
    */
    readonly hashKeyType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#hash_key_value IotTopicRule#hash_key_value}
    */
    readonly hashKeyValue: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#operation IotTopicRule#operation}
    */
    readonly operation?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#payload_field IotTopicRule#payload_field}
    */
    readonly payloadField?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#range_key_field IotTopicRule#range_key_field}
    */
    readonly rangeKeyField?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#range_key_type IotTopicRule#range_key_type}
    */
    readonly rangeKeyType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#range_key_value IotTopicRule#range_key_value}
    */
    readonly rangeKeyValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#table_name IotTopicRule#table_name}
    */
    readonly tableName: string;
}
export declare function iotTopicRuleErrorActionDynamodbToTerraform(struct?: IotTopicRuleErrorActionDynamodbOutputReference | IotTopicRuleErrorActionDynamodb): any;
export declare class IotTopicRuleErrorActionDynamodbOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionDynamodb | undefined;
    set internalValue(value: IotTopicRuleErrorActionDynamodb | undefined);
    private _hashKeyField?;
    get hashKeyField(): string;
    set hashKeyField(value: string);
    get hashKeyFieldInput(): string | undefined;
    private _hashKeyType?;
    get hashKeyType(): string;
    set hashKeyType(value: string);
    resetHashKeyType(): void;
    get hashKeyTypeInput(): string | undefined;
    private _hashKeyValue?;
    get hashKeyValue(): string;
    set hashKeyValue(value: string);
    get hashKeyValueInput(): string | undefined;
    private _operation?;
    get operation(): string;
    set operation(value: string);
    resetOperation(): void;
    get operationInput(): string | undefined;
    private _payloadField?;
    get payloadField(): string;
    set payloadField(value: string);
    resetPayloadField(): void;
    get payloadFieldInput(): string | undefined;
    private _rangeKeyField?;
    get rangeKeyField(): string;
    set rangeKeyField(value: string);
    resetRangeKeyField(): void;
    get rangeKeyFieldInput(): string | undefined;
    private _rangeKeyType?;
    get rangeKeyType(): string;
    set rangeKeyType(value: string);
    resetRangeKeyType(): void;
    get rangeKeyTypeInput(): string | undefined;
    private _rangeKeyValue?;
    get rangeKeyValue(): string;
    set rangeKeyValue(value: string);
    resetRangeKeyValue(): void;
    get rangeKeyValueInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
    private _tableName?;
    get tableName(): string;
    set tableName(value: string);
    get tableNameInput(): string | undefined;
}
export interface IotTopicRuleErrorActionDynamodbv2PutItem {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#table_name IotTopicRule#table_name}
    */
    readonly tableName: string;
}
export declare function iotTopicRuleErrorActionDynamodbv2PutItemToTerraform(struct?: IotTopicRuleErrorActionDynamodbv2PutItemOutputReference | IotTopicRuleErrorActionDynamodbv2PutItem): any;
export declare class IotTopicRuleErrorActionDynamodbv2PutItemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionDynamodbv2PutItem | undefined;
    set internalValue(value: IotTopicRuleErrorActionDynamodbv2PutItem | undefined);
    private _tableName?;
    get tableName(): string;
    set tableName(value: string);
    get tableNameInput(): string | undefined;
}
export interface IotTopicRuleErrorActionDynamodbv2 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * put_item block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#put_item IotTopicRule#put_item}
    */
    readonly putItem?: IotTopicRuleErrorActionDynamodbv2PutItem;
}
export declare function iotTopicRuleErrorActionDynamodbv2ToTerraform(struct?: IotTopicRuleErrorActionDynamodbv2OutputReference | IotTopicRuleErrorActionDynamodbv2): any;
export declare class IotTopicRuleErrorActionDynamodbv2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionDynamodbv2 | undefined;
    set internalValue(value: IotTopicRuleErrorActionDynamodbv2 | undefined);
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
    private _putItem;
    get putItem(): IotTopicRuleErrorActionDynamodbv2PutItemOutputReference;
    putPutItem(value: IotTopicRuleErrorActionDynamodbv2PutItem): void;
    resetPutItem(): void;
    get putItemInput(): IotTopicRuleErrorActionDynamodbv2PutItem | undefined;
}
export interface IotTopicRuleErrorActionElasticsearch {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#endpoint IotTopicRule#endpoint}
    */
    readonly endpoint: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#id IotTopicRule#id}
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#index IotTopicRule#index}
    */
    readonly index: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#type IotTopicRule#type}
    */
    readonly type: string;
}
export declare function iotTopicRuleErrorActionElasticsearchToTerraform(struct?: IotTopicRuleErrorActionElasticsearchOutputReference | IotTopicRuleErrorActionElasticsearch): any;
export declare class IotTopicRuleErrorActionElasticsearchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionElasticsearch | undefined;
    set internalValue(value: IotTopicRuleErrorActionElasticsearch | undefined);
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    get endpointInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface IotTopicRuleErrorActionFirehose {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#delivery_stream_name IotTopicRule#delivery_stream_name}
    */
    readonly deliveryStreamName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#separator IotTopicRule#separator}
    */
    readonly separator?: string;
}
export declare function iotTopicRuleErrorActionFirehoseToTerraform(struct?: IotTopicRuleErrorActionFirehoseOutputReference | IotTopicRuleErrorActionFirehose): any;
export declare class IotTopicRuleErrorActionFirehoseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionFirehose | undefined;
    set internalValue(value: IotTopicRuleErrorActionFirehose | undefined);
    private _deliveryStreamName?;
    get deliveryStreamName(): string;
    set deliveryStreamName(value: string);
    get deliveryStreamNameInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
    private _separator?;
    get separator(): string;
    set separator(value: string);
    resetSeparator(): void;
    get separatorInput(): string | undefined;
}
export interface IotTopicRuleErrorActionHttpHttpHeader {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#key IotTopicRule#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#value IotTopicRule#value}
    */
    readonly value: string;
}
export declare function iotTopicRuleErrorActionHttpHttpHeaderToTerraform(struct?: IotTopicRuleErrorActionHttpHttpHeader | cdktf.IResolvable): any;
export interface IotTopicRuleErrorActionHttp {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#confirmation_url IotTopicRule#confirmation_url}
    */
    readonly confirmationUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#url IotTopicRule#url}
    */
    readonly url: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#http_header IotTopicRule#http_header}
    */
    readonly httpHeader?: IotTopicRuleErrorActionHttpHttpHeader[] | cdktf.IResolvable;
}
export declare function iotTopicRuleErrorActionHttpToTerraform(struct?: IotTopicRuleErrorActionHttpOutputReference | IotTopicRuleErrorActionHttp): any;
export declare class IotTopicRuleErrorActionHttpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionHttp | undefined;
    set internalValue(value: IotTopicRuleErrorActionHttp | undefined);
    private _confirmationUrl?;
    get confirmationUrl(): string;
    set confirmationUrl(value: string);
    resetConfirmationUrl(): void;
    get confirmationUrlInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _httpHeader?;
    get httpHeader(): IotTopicRuleErrorActionHttpHttpHeader[] | cdktf.IResolvable;
    set httpHeader(value: IotTopicRuleErrorActionHttpHttpHeader[] | cdktf.IResolvable);
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | IotTopicRuleErrorActionHttpHttpHeader[] | undefined;
}
export interface IotTopicRuleErrorActionIotAnalytics {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#channel_name IotTopicRule#channel_name}
    */
    readonly channelName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
}
export declare function iotTopicRuleErrorActionIotAnalyticsToTerraform(struct?: IotTopicRuleErrorActionIotAnalyticsOutputReference | IotTopicRuleErrorActionIotAnalytics): any;
export declare class IotTopicRuleErrorActionIotAnalyticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionIotAnalytics | undefined;
    set internalValue(value: IotTopicRuleErrorActionIotAnalytics | undefined);
    private _channelName?;
    get channelName(): string;
    set channelName(value: string);
    get channelNameInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
}
export interface IotTopicRuleErrorActionIotEvents {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#input_name IotTopicRule#input_name}
    */
    readonly inputName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#message_id IotTopicRule#message_id}
    */
    readonly messageId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
}
export declare function iotTopicRuleErrorActionIotEventsToTerraform(struct?: IotTopicRuleErrorActionIotEventsOutputReference | IotTopicRuleErrorActionIotEvents): any;
export declare class IotTopicRuleErrorActionIotEventsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionIotEvents | undefined;
    set internalValue(value: IotTopicRuleErrorActionIotEvents | undefined);
    private _inputName?;
    get inputName(): string;
    set inputName(value: string);
    get inputNameInput(): string | undefined;
    private _messageId?;
    get messageId(): string;
    set messageId(value: string);
    resetMessageId(): void;
    get messageIdInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
}
export interface IotTopicRuleErrorActionKafka {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#client_properties IotTopicRule#client_properties}
    */
    readonly clientProperties: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#destination_arn IotTopicRule#destination_arn}
    */
    readonly destinationArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#key IotTopicRule#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#partition IotTopicRule#partition}
    */
    readonly partition?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#topic IotTopicRule#topic}
    */
    readonly topic: string;
}
export declare function iotTopicRuleErrorActionKafkaToTerraform(struct?: IotTopicRuleErrorActionKafkaOutputReference | IotTopicRuleErrorActionKafka): any;
export declare class IotTopicRuleErrorActionKafkaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionKafka | undefined;
    set internalValue(value: IotTopicRuleErrorActionKafka | undefined);
    private _clientProperties?;
    get clientProperties(): {
        [key: string]: string;
    };
    set clientProperties(value: {
        [key: string]: string;
    });
    get clientPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _destinationArn?;
    get destinationArn(): string;
    set destinationArn(value: string);
    get destinationArnInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
}
export interface IotTopicRuleErrorActionKinesis {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#partition_key IotTopicRule#partition_key}
    */
    readonly partitionKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#stream_name IotTopicRule#stream_name}
    */
    readonly streamName: string;
}
export declare function iotTopicRuleErrorActionKinesisToTerraform(struct?: IotTopicRuleErrorActionKinesisOutputReference | IotTopicRuleErrorActionKinesis): any;
export declare class IotTopicRuleErrorActionKinesisOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionKinesis | undefined;
    set internalValue(value: IotTopicRuleErrorActionKinesis | undefined);
    private _partitionKey?;
    get partitionKey(): string;
    set partitionKey(value: string);
    resetPartitionKey(): void;
    get partitionKeyInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
    private _streamName?;
    get streamName(): string;
    set streamName(value: string);
    get streamNameInput(): string | undefined;
}
export interface IotTopicRuleErrorActionLambda {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#function_arn IotTopicRule#function_arn}
    */
    readonly functionArn: string;
}
export declare function iotTopicRuleErrorActionLambdaToTerraform(struct?: IotTopicRuleErrorActionLambdaOutputReference | IotTopicRuleErrorActionLambda): any;
export declare class IotTopicRuleErrorActionLambdaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionLambda | undefined;
    set internalValue(value: IotTopicRuleErrorActionLambda | undefined);
    private _functionArn?;
    get functionArn(): string;
    set functionArn(value: string);
    get functionArnInput(): string | undefined;
}
export interface IotTopicRuleErrorActionRepublish {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#qos IotTopicRule#qos}
    */
    readonly qos?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#topic IotTopicRule#topic}
    */
    readonly topic: string;
}
export declare function iotTopicRuleErrorActionRepublishToTerraform(struct?: IotTopicRuleErrorActionRepublishOutputReference | IotTopicRuleErrorActionRepublish): any;
export declare class IotTopicRuleErrorActionRepublishOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionRepublish | undefined;
    set internalValue(value: IotTopicRuleErrorActionRepublish | undefined);
    private _qos?;
    get qos(): number;
    set qos(value: number);
    resetQos(): void;
    get qosInput(): number | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
}
export interface IotTopicRuleErrorActionS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#bucket_name IotTopicRule#bucket_name}
    */
    readonly bucketName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#canned_acl IotTopicRule#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#key IotTopicRule#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
}
export declare function iotTopicRuleErrorActionS3ToTerraform(struct?: IotTopicRuleErrorActionS3OutputReference | IotTopicRuleErrorActionS3): any;
export declare class IotTopicRuleErrorActionS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionS3 | undefined;
    set internalValue(value: IotTopicRuleErrorActionS3 | undefined);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _cannedAcl?;
    get cannedAcl(): string;
    set cannedAcl(value: string);
    resetCannedAcl(): void;
    get cannedAclInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
}
export interface IotTopicRuleErrorActionSns {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#message_format IotTopicRule#message_format}
    */
    readonly messageFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#target_arn IotTopicRule#target_arn}
    */
    readonly targetArn: string;
}
export declare function iotTopicRuleErrorActionSnsToTerraform(struct?: IotTopicRuleErrorActionSnsOutputReference | IotTopicRuleErrorActionSns): any;
export declare class IotTopicRuleErrorActionSnsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionSns | undefined;
    set internalValue(value: IotTopicRuleErrorActionSns | undefined);
    private _messageFormat?;
    get messageFormat(): string;
    set messageFormat(value: string);
    resetMessageFormat(): void;
    get messageFormatInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
    private _targetArn?;
    get targetArn(): string;
    set targetArn(value: string);
    get targetArnInput(): string | undefined;
}
export interface IotTopicRuleErrorActionSqs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#queue_url IotTopicRule#queue_url}
    */
    readonly queueUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#use_base64 IotTopicRule#use_base64}
    */
    readonly useBase64: boolean | cdktf.IResolvable;
}
export declare function iotTopicRuleErrorActionSqsToTerraform(struct?: IotTopicRuleErrorActionSqsOutputReference | IotTopicRuleErrorActionSqs): any;
export declare class IotTopicRuleErrorActionSqsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionSqs | undefined;
    set internalValue(value: IotTopicRuleErrorActionSqs | undefined);
    private _queueUrl?;
    get queueUrl(): string;
    set queueUrl(value: string);
    get queueUrlInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
    private _useBase64?;
    get useBase64(): boolean | cdktf.IResolvable;
    set useBase64(value: boolean | cdktf.IResolvable);
    get useBase64Input(): boolean | cdktf.IResolvable | undefined;
}
export interface IotTopicRuleErrorActionStepFunctions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#execution_name_prefix IotTopicRule#execution_name_prefix}
    */
    readonly executionNamePrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#state_machine_name IotTopicRule#state_machine_name}
    */
    readonly stateMachineName: string;
}
export declare function iotTopicRuleErrorActionStepFunctionsToTerraform(struct?: IotTopicRuleErrorActionStepFunctionsOutputReference | IotTopicRuleErrorActionStepFunctions): any;
export declare class IotTopicRuleErrorActionStepFunctionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionStepFunctions | undefined;
    set internalValue(value: IotTopicRuleErrorActionStepFunctions | undefined);
    private _executionNamePrefix?;
    get executionNamePrefix(): string;
    set executionNamePrefix(value: string);
    resetExecutionNamePrefix(): void;
    get executionNamePrefixInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
    private _stateMachineName?;
    get stateMachineName(): string;
    set stateMachineName(value: string);
    get stateMachineNameInput(): string | undefined;
}
export interface IotTopicRuleErrorActionTimestreamDimension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#name IotTopicRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#value IotTopicRule#value}
    */
    readonly value: string;
}
export declare function iotTopicRuleErrorActionTimestreamDimensionToTerraform(struct?: IotTopicRuleErrorActionTimestreamDimension | cdktf.IResolvable): any;
export interface IotTopicRuleErrorActionTimestreamTimestamp {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#unit IotTopicRule#unit}
    */
    readonly unit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#value IotTopicRule#value}
    */
    readonly value: string;
}
export declare function iotTopicRuleErrorActionTimestreamTimestampToTerraform(struct?: IotTopicRuleErrorActionTimestreamTimestampOutputReference | IotTopicRuleErrorActionTimestreamTimestamp): any;
export declare class IotTopicRuleErrorActionTimestreamTimestampOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionTimestreamTimestamp | undefined;
    set internalValue(value: IotTopicRuleErrorActionTimestreamTimestamp | undefined);
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export interface IotTopicRuleErrorActionTimestream {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#database_name IotTopicRule#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#table_name IotTopicRule#table_name}
    */
    readonly tableName: string;
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#dimension IotTopicRule#dimension}
    */
    readonly dimension: IotTopicRuleErrorActionTimestreamDimension[] | cdktf.IResolvable;
    /**
    * timestamp block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#timestamp IotTopicRule#timestamp}
    */
    readonly timestamp?: IotTopicRuleErrorActionTimestreamTimestamp;
}
export declare function iotTopicRuleErrorActionTimestreamToTerraform(struct?: IotTopicRuleErrorActionTimestreamOutputReference | IotTopicRuleErrorActionTimestream): any;
export declare class IotTopicRuleErrorActionTimestreamOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorActionTimestream | undefined;
    set internalValue(value: IotTopicRuleErrorActionTimestream | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
    private _tableName?;
    get tableName(): string;
    set tableName(value: string);
    get tableNameInput(): string | undefined;
    private _dimension?;
    get dimension(): IotTopicRuleErrorActionTimestreamDimension[] | cdktf.IResolvable;
    set dimension(value: IotTopicRuleErrorActionTimestreamDimension[] | cdktf.IResolvable);
    get dimensionInput(): cdktf.IResolvable | IotTopicRuleErrorActionTimestreamDimension[] | undefined;
    private _timestamp;
    get timestamp(): IotTopicRuleErrorActionTimestreamTimestampOutputReference;
    putTimestamp(value: IotTopicRuleErrorActionTimestreamTimestamp): void;
    resetTimestamp(): void;
    get timestampInput(): IotTopicRuleErrorActionTimestreamTimestamp | undefined;
}
export interface IotTopicRuleErrorAction {
    /**
    * cloudwatch_alarm block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#cloudwatch_alarm IotTopicRule#cloudwatch_alarm}
    */
    readonly cloudwatchAlarm?: IotTopicRuleErrorActionCloudwatchAlarm;
    /**
    * cloudwatch_logs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#cloudwatch_logs IotTopicRule#cloudwatch_logs}
    */
    readonly cloudwatchLogs?: IotTopicRuleErrorActionCloudwatchLogs;
    /**
    * cloudwatch_metric block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#cloudwatch_metric IotTopicRule#cloudwatch_metric}
    */
    readonly cloudwatchMetric?: IotTopicRuleErrorActionCloudwatchMetric;
    /**
    * dynamodb block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#dynamodb IotTopicRule#dynamodb}
    */
    readonly dynamodb?: IotTopicRuleErrorActionDynamodb;
    /**
    * dynamodbv2 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#dynamodbv2 IotTopicRule#dynamodbv2}
    */
    readonly dynamodbv2?: IotTopicRuleErrorActionDynamodbv2;
    /**
    * elasticsearch block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#elasticsearch IotTopicRule#elasticsearch}
    */
    readonly elasticsearch?: IotTopicRuleErrorActionElasticsearch;
    /**
    * firehose block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#firehose IotTopicRule#firehose}
    */
    readonly firehose?: IotTopicRuleErrorActionFirehose;
    /**
    * http block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#http IotTopicRule#http}
    */
    readonly http?: IotTopicRuleErrorActionHttp;
    /**
    * iot_analytics block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#iot_analytics IotTopicRule#iot_analytics}
    */
    readonly iotAnalytics?: IotTopicRuleErrorActionIotAnalytics;
    /**
    * iot_events block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#iot_events IotTopicRule#iot_events}
    */
    readonly iotEvents?: IotTopicRuleErrorActionIotEvents;
    /**
    * kafka block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#kafka IotTopicRule#kafka}
    */
    readonly kafka?: IotTopicRuleErrorActionKafka;
    /**
    * kinesis block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#kinesis IotTopicRule#kinesis}
    */
    readonly kinesis?: IotTopicRuleErrorActionKinesis;
    /**
    * lambda block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#lambda IotTopicRule#lambda}
    */
    readonly lambda?: IotTopicRuleErrorActionLambda;
    /**
    * republish block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#republish IotTopicRule#republish}
    */
    readonly republish?: IotTopicRuleErrorActionRepublish;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#s3 IotTopicRule#s3}
    */
    readonly s3?: IotTopicRuleErrorActionS3;
    /**
    * sns block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#sns IotTopicRule#sns}
    */
    readonly sns?: IotTopicRuleErrorActionSns;
    /**
    * sqs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#sqs IotTopicRule#sqs}
    */
    readonly sqs?: IotTopicRuleErrorActionSqs;
    /**
    * step_functions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#step_functions IotTopicRule#step_functions}
    */
    readonly stepFunctions?: IotTopicRuleErrorActionStepFunctions;
    /**
    * timestream block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#timestream IotTopicRule#timestream}
    */
    readonly timestream?: IotTopicRuleErrorActionTimestream;
}
export declare function iotTopicRuleErrorActionToTerraform(struct?: IotTopicRuleErrorActionOutputReference | IotTopicRuleErrorAction): any;
export declare class IotTopicRuleErrorActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleErrorAction | undefined;
    set internalValue(value: IotTopicRuleErrorAction | undefined);
    private _cloudwatchAlarm;
    get cloudwatchAlarm(): IotTopicRuleErrorActionCloudwatchAlarmOutputReference;
    putCloudwatchAlarm(value: IotTopicRuleErrorActionCloudwatchAlarm): void;
    resetCloudwatchAlarm(): void;
    get cloudwatchAlarmInput(): IotTopicRuleErrorActionCloudwatchAlarm | undefined;
    private _cloudwatchLogs;
    get cloudwatchLogs(): IotTopicRuleErrorActionCloudwatchLogsOutputReference;
    putCloudwatchLogs(value: IotTopicRuleErrorActionCloudwatchLogs): void;
    resetCloudwatchLogs(): void;
    get cloudwatchLogsInput(): IotTopicRuleErrorActionCloudwatchLogs | undefined;
    private _cloudwatchMetric;
    get cloudwatchMetric(): IotTopicRuleErrorActionCloudwatchMetricOutputReference;
    putCloudwatchMetric(value: IotTopicRuleErrorActionCloudwatchMetric): void;
    resetCloudwatchMetric(): void;
    get cloudwatchMetricInput(): IotTopicRuleErrorActionCloudwatchMetric | undefined;
    private _dynamodb;
    get dynamodb(): IotTopicRuleErrorActionDynamodbOutputReference;
    putDynamodb(value: IotTopicRuleErrorActionDynamodb): void;
    resetDynamodb(): void;
    get dynamodbInput(): IotTopicRuleErrorActionDynamodb | undefined;
    private _dynamodbv2;
    get dynamodbv2(): IotTopicRuleErrorActionDynamodbv2OutputReference;
    putDynamodbv2(value: IotTopicRuleErrorActionDynamodbv2): void;
    resetDynamodbv2(): void;
    get dynamodbv2Input(): IotTopicRuleErrorActionDynamodbv2 | undefined;
    private _elasticsearch;
    get elasticsearch(): IotTopicRuleErrorActionElasticsearchOutputReference;
    putElasticsearch(value: IotTopicRuleErrorActionElasticsearch): void;
    resetElasticsearch(): void;
    get elasticsearchInput(): IotTopicRuleErrorActionElasticsearch | undefined;
    private _firehose;
    get firehose(): IotTopicRuleErrorActionFirehoseOutputReference;
    putFirehose(value: IotTopicRuleErrorActionFirehose): void;
    resetFirehose(): void;
    get firehoseInput(): IotTopicRuleErrorActionFirehose | undefined;
    private _http;
    get http(): IotTopicRuleErrorActionHttpOutputReference;
    putHttp(value: IotTopicRuleErrorActionHttp): void;
    resetHttp(): void;
    get httpInput(): IotTopicRuleErrorActionHttp | undefined;
    private _iotAnalytics;
    get iotAnalytics(): IotTopicRuleErrorActionIotAnalyticsOutputReference;
    putIotAnalytics(value: IotTopicRuleErrorActionIotAnalytics): void;
    resetIotAnalytics(): void;
    get iotAnalyticsInput(): IotTopicRuleErrorActionIotAnalytics | undefined;
    private _iotEvents;
    get iotEvents(): IotTopicRuleErrorActionIotEventsOutputReference;
    putIotEvents(value: IotTopicRuleErrorActionIotEvents): void;
    resetIotEvents(): void;
    get iotEventsInput(): IotTopicRuleErrorActionIotEvents | undefined;
    private _kafka;
    get kafka(): IotTopicRuleErrorActionKafkaOutputReference;
    putKafka(value: IotTopicRuleErrorActionKafka): void;
    resetKafka(): void;
    get kafkaInput(): IotTopicRuleErrorActionKafka | undefined;
    private _kinesis;
    get kinesis(): IotTopicRuleErrorActionKinesisOutputReference;
    putKinesis(value: IotTopicRuleErrorActionKinesis): void;
    resetKinesis(): void;
    get kinesisInput(): IotTopicRuleErrorActionKinesis | undefined;
    private _lambda;
    get lambda(): IotTopicRuleErrorActionLambdaOutputReference;
    putLambda(value: IotTopicRuleErrorActionLambda): void;
    resetLambda(): void;
    get lambdaInput(): IotTopicRuleErrorActionLambda | undefined;
    private _republish;
    get republish(): IotTopicRuleErrorActionRepublishOutputReference;
    putRepublish(value: IotTopicRuleErrorActionRepublish): void;
    resetRepublish(): void;
    get republishInput(): IotTopicRuleErrorActionRepublish | undefined;
    private _s3;
    get s3(): IotTopicRuleErrorActionS3OutputReference;
    putS3(value: IotTopicRuleErrorActionS3): void;
    resetS3(): void;
    get s3Input(): IotTopicRuleErrorActionS3 | undefined;
    private _sns;
    get sns(): IotTopicRuleErrorActionSnsOutputReference;
    putSns(value: IotTopicRuleErrorActionSns): void;
    resetSns(): void;
    get snsInput(): IotTopicRuleErrorActionSns | undefined;
    private _sqs;
    get sqs(): IotTopicRuleErrorActionSqsOutputReference;
    putSqs(value: IotTopicRuleErrorActionSqs): void;
    resetSqs(): void;
    get sqsInput(): IotTopicRuleErrorActionSqs | undefined;
    private _stepFunctions;
    get stepFunctions(): IotTopicRuleErrorActionStepFunctionsOutputReference;
    putStepFunctions(value: IotTopicRuleErrorActionStepFunctions): void;
    resetStepFunctions(): void;
    get stepFunctionsInput(): IotTopicRuleErrorActionStepFunctions | undefined;
    private _timestream;
    get timestream(): IotTopicRuleErrorActionTimestreamOutputReference;
    putTimestream(value: IotTopicRuleErrorActionTimestream): void;
    resetTimestream(): void;
    get timestreamInput(): IotTopicRuleErrorActionTimestream | undefined;
}
export interface IotTopicRuleFirehose {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#delivery_stream_name IotTopicRule#delivery_stream_name}
    */
    readonly deliveryStreamName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#separator IotTopicRule#separator}
    */
    readonly separator?: string;
}
export declare function iotTopicRuleFirehoseToTerraform(struct?: IotTopicRuleFirehose | cdktf.IResolvable): any;
export interface IotTopicRuleHttpHttpHeader {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#key IotTopicRule#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#value IotTopicRule#value}
    */
    readonly value: string;
}
export declare function iotTopicRuleHttpHttpHeaderToTerraform(struct?: IotTopicRuleHttpHttpHeader | cdktf.IResolvable): any;
export interface IotTopicRuleHttp {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#confirmation_url IotTopicRule#confirmation_url}
    */
    readonly confirmationUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#url IotTopicRule#url}
    */
    readonly url: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#http_header IotTopicRule#http_header}
    */
    readonly httpHeader?: IotTopicRuleHttpHttpHeader[] | cdktf.IResolvable;
}
export declare function iotTopicRuleHttpToTerraform(struct?: IotTopicRuleHttp | cdktf.IResolvable): any;
export interface IotTopicRuleIotAnalytics {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#channel_name IotTopicRule#channel_name}
    */
    readonly channelName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
}
export declare function iotTopicRuleIotAnalyticsToTerraform(struct?: IotTopicRuleIotAnalytics | cdktf.IResolvable): any;
export interface IotTopicRuleIotEvents {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#input_name IotTopicRule#input_name}
    */
    readonly inputName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#message_id IotTopicRule#message_id}
    */
    readonly messageId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
}
export declare function iotTopicRuleIotEventsToTerraform(struct?: IotTopicRuleIotEvents | cdktf.IResolvable): any;
export interface IotTopicRuleKafka {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#client_properties IotTopicRule#client_properties}
    */
    readonly clientProperties: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#destination_arn IotTopicRule#destination_arn}
    */
    readonly destinationArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#key IotTopicRule#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#partition IotTopicRule#partition}
    */
    readonly partition?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#topic IotTopicRule#topic}
    */
    readonly topic: string;
}
export declare function iotTopicRuleKafkaToTerraform(struct?: IotTopicRuleKafka | cdktf.IResolvable): any;
export interface IotTopicRuleKinesis {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#partition_key IotTopicRule#partition_key}
    */
    readonly partitionKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#stream_name IotTopicRule#stream_name}
    */
    readonly streamName: string;
}
export declare function iotTopicRuleKinesisToTerraform(struct?: IotTopicRuleKinesis | cdktf.IResolvable): any;
export interface IotTopicRuleLambda {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#function_arn IotTopicRule#function_arn}
    */
    readonly functionArn: string;
}
export declare function iotTopicRuleLambdaToTerraform(struct?: IotTopicRuleLambda | cdktf.IResolvable): any;
export interface IotTopicRuleRepublish {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#qos IotTopicRule#qos}
    */
    readonly qos?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#topic IotTopicRule#topic}
    */
    readonly topic: string;
}
export declare function iotTopicRuleRepublishToTerraform(struct?: IotTopicRuleRepublish | cdktf.IResolvable): any;
export interface IotTopicRuleS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#bucket_name IotTopicRule#bucket_name}
    */
    readonly bucketName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#canned_acl IotTopicRule#canned_acl}
    */
    readonly cannedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#key IotTopicRule#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
}
export declare function iotTopicRuleS3ToTerraform(struct?: IotTopicRuleS3 | cdktf.IResolvable): any;
export interface IotTopicRuleSns {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#message_format IotTopicRule#message_format}
    */
    readonly messageFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#target_arn IotTopicRule#target_arn}
    */
    readonly targetArn: string;
}
export declare function iotTopicRuleSnsToTerraform(struct?: IotTopicRuleSns | cdktf.IResolvable): any;
export interface IotTopicRuleSqs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#queue_url IotTopicRule#queue_url}
    */
    readonly queueUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#use_base64 IotTopicRule#use_base64}
    */
    readonly useBase64: boolean | cdktf.IResolvable;
}
export declare function iotTopicRuleSqsToTerraform(struct?: IotTopicRuleSqs | cdktf.IResolvable): any;
export interface IotTopicRuleStepFunctions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#execution_name_prefix IotTopicRule#execution_name_prefix}
    */
    readonly executionNamePrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#state_machine_name IotTopicRule#state_machine_name}
    */
    readonly stateMachineName: string;
}
export declare function iotTopicRuleStepFunctionsToTerraform(struct?: IotTopicRuleStepFunctions | cdktf.IResolvable): any;
export interface IotTopicRuleTimestreamDimension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#name IotTopicRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#value IotTopicRule#value}
    */
    readonly value: string;
}
export declare function iotTopicRuleTimestreamDimensionToTerraform(struct?: IotTopicRuleTimestreamDimension | cdktf.IResolvable): any;
export interface IotTopicRuleTimestreamTimestamp {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#unit IotTopicRule#unit}
    */
    readonly unit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#value IotTopicRule#value}
    */
    readonly value: string;
}
export declare function iotTopicRuleTimestreamTimestampToTerraform(struct?: IotTopicRuleTimestreamTimestampOutputReference | IotTopicRuleTimestreamTimestamp): any;
export declare class IotTopicRuleTimestreamTimestampOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotTopicRuleTimestreamTimestamp | undefined;
    set internalValue(value: IotTopicRuleTimestreamTimestamp | undefined);
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export interface IotTopicRuleTimestream {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#database_name IotTopicRule#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#role_arn IotTopicRule#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#table_name IotTopicRule#table_name}
    */
    readonly tableName: string;
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#dimension IotTopicRule#dimension}
    */
    readonly dimension: IotTopicRuleTimestreamDimension[] | cdktf.IResolvable;
    /**
    * timestamp block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule#timestamp IotTopicRule#timestamp}
    */
    readonly timestamp?: IotTopicRuleTimestreamTimestamp;
}
export declare function iotTopicRuleTimestreamToTerraform(struct?: IotTopicRuleTimestream | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule aws_iot_topic_rule}
*/
export declare class IotTopicRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_iot_topic_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/iot_topic_rule aws_iot_topic_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IotTopicRuleConfig
    */
    constructor(scope: Construct, id: string, config: IotTopicRuleConfig);
    get arn(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sql?;
    get sql(): string;
    set sql(value: string);
    get sqlInput(): string | undefined;
    private _sqlVersion?;
    get sqlVersion(): string;
    set sqlVersion(value: string);
    get sqlVersionInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _cloudwatchAlarm?;
    get cloudwatchAlarm(): IotTopicRuleCloudwatchAlarm[] | cdktf.IResolvable;
    set cloudwatchAlarm(value: IotTopicRuleCloudwatchAlarm[] | cdktf.IResolvable);
    resetCloudwatchAlarm(): void;
    get cloudwatchAlarmInput(): cdktf.IResolvable | IotTopicRuleCloudwatchAlarm[] | undefined;
    private _cloudwatchLogs?;
    get cloudwatchLogs(): IotTopicRuleCloudwatchLogs[] | cdktf.IResolvable;
    set cloudwatchLogs(value: IotTopicRuleCloudwatchLogs[] | cdktf.IResolvable);
    resetCloudwatchLogs(): void;
    get cloudwatchLogsInput(): cdktf.IResolvable | IotTopicRuleCloudwatchLogs[] | undefined;
    private _cloudwatchMetric?;
    get cloudwatchMetric(): IotTopicRuleCloudwatchMetric[] | cdktf.IResolvable;
    set cloudwatchMetric(value: IotTopicRuleCloudwatchMetric[] | cdktf.IResolvable);
    resetCloudwatchMetric(): void;
    get cloudwatchMetricInput(): cdktf.IResolvable | IotTopicRuleCloudwatchMetric[] | undefined;
    private _dynamodb?;
    get dynamodb(): IotTopicRuleDynamodb[] | cdktf.IResolvable;
    set dynamodb(value: IotTopicRuleDynamodb[] | cdktf.IResolvable);
    resetDynamodb(): void;
    get dynamodbInput(): cdktf.IResolvable | IotTopicRuleDynamodb[] | undefined;
    private _dynamodbv2?;
    get dynamodbv2(): IotTopicRuleDynamodbv2[] | cdktf.IResolvable;
    set dynamodbv2(value: IotTopicRuleDynamodbv2[] | cdktf.IResolvable);
    resetDynamodbv2(): void;
    get dynamodbv2Input(): cdktf.IResolvable | IotTopicRuleDynamodbv2[] | undefined;
    private _elasticsearch?;
    get elasticsearch(): IotTopicRuleElasticsearch[] | cdktf.IResolvable;
    set elasticsearch(value: IotTopicRuleElasticsearch[] | cdktf.IResolvable);
    resetElasticsearch(): void;
    get elasticsearchInput(): cdktf.IResolvable | IotTopicRuleElasticsearch[] | undefined;
    private _errorAction;
    get errorAction(): IotTopicRuleErrorActionOutputReference;
    putErrorAction(value: IotTopicRuleErrorAction): void;
    resetErrorAction(): void;
    get errorActionInput(): IotTopicRuleErrorAction | undefined;
    private _firehose?;
    get firehose(): IotTopicRuleFirehose[] | cdktf.IResolvable;
    set firehose(value: IotTopicRuleFirehose[] | cdktf.IResolvable);
    resetFirehose(): void;
    get firehoseInput(): cdktf.IResolvable | IotTopicRuleFirehose[] | undefined;
    private _http?;
    get http(): IotTopicRuleHttp[] | cdktf.IResolvable;
    set http(value: IotTopicRuleHttp[] | cdktf.IResolvable);
    resetHttp(): void;
    get httpInput(): cdktf.IResolvable | IotTopicRuleHttp[] | undefined;
    private _iotAnalytics?;
    get iotAnalytics(): IotTopicRuleIotAnalytics[] | cdktf.IResolvable;
    set iotAnalytics(value: IotTopicRuleIotAnalytics[] | cdktf.IResolvable);
    resetIotAnalytics(): void;
    get iotAnalyticsInput(): cdktf.IResolvable | IotTopicRuleIotAnalytics[] | undefined;
    private _iotEvents?;
    get iotEvents(): IotTopicRuleIotEvents[] | cdktf.IResolvable;
    set iotEvents(value: IotTopicRuleIotEvents[] | cdktf.IResolvable);
    resetIotEvents(): void;
    get iotEventsInput(): cdktf.IResolvable | IotTopicRuleIotEvents[] | undefined;
    private _kafka?;
    get kafka(): IotTopicRuleKafka[] | cdktf.IResolvable;
    set kafka(value: IotTopicRuleKafka[] | cdktf.IResolvable);
    resetKafka(): void;
    get kafkaInput(): cdktf.IResolvable | IotTopicRuleKafka[] | undefined;
    private _kinesis?;
    get kinesis(): IotTopicRuleKinesis[] | cdktf.IResolvable;
    set kinesis(value: IotTopicRuleKinesis[] | cdktf.IResolvable);
    resetKinesis(): void;
    get kinesisInput(): cdktf.IResolvable | IotTopicRuleKinesis[] | undefined;
    private _lambda?;
    get lambda(): IotTopicRuleLambda[] | cdktf.IResolvable;
    set lambda(value: IotTopicRuleLambda[] | cdktf.IResolvable);
    resetLambda(): void;
    get lambdaInput(): cdktf.IResolvable | IotTopicRuleLambda[] | undefined;
    private _republish?;
    get republish(): IotTopicRuleRepublish[] | cdktf.IResolvable;
    set republish(value: IotTopicRuleRepublish[] | cdktf.IResolvable);
    resetRepublish(): void;
    get republishInput(): cdktf.IResolvable | IotTopicRuleRepublish[] | undefined;
    private _s3?;
    get s3(): IotTopicRuleS3[] | cdktf.IResolvable;
    set s3(value: IotTopicRuleS3[] | cdktf.IResolvable);
    resetS3(): void;
    get s3Input(): cdktf.IResolvable | IotTopicRuleS3[] | undefined;
    private _sns?;
    get sns(): IotTopicRuleSns[] | cdktf.IResolvable;
    set sns(value: IotTopicRuleSns[] | cdktf.IResolvable);
    resetSns(): void;
    get snsInput(): cdktf.IResolvable | IotTopicRuleSns[] | undefined;
    private _sqs?;
    get sqs(): IotTopicRuleSqs[] | cdktf.IResolvable;
    set sqs(value: IotTopicRuleSqs[] | cdktf.IResolvable);
    resetSqs(): void;
    get sqsInput(): cdktf.IResolvable | IotTopicRuleSqs[] | undefined;
    private _stepFunctions?;
    get stepFunctions(): IotTopicRuleStepFunctions[] | cdktf.IResolvable;
    set stepFunctions(value: IotTopicRuleStepFunctions[] | cdktf.IResolvable);
    resetStepFunctions(): void;
    get stepFunctionsInput(): cdktf.IResolvable | IotTopicRuleStepFunctions[] | undefined;
    private _timestream?;
    get timestream(): IotTopicRuleTimestream[] | cdktf.IResolvable;
    set timestream(value: IotTopicRuleTimestream[] | cdktf.IResolvable);
    resetTimestream(): void;
    get timestreamInput(): cdktf.IResolvable | IotTopicRuleTimestream[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=iot-topic-rule.d.ts.map