import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KeyspacesKeyspaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/keyspaces_keyspace#name KeyspacesKeyspace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/keyspaces_keyspace#tags KeyspacesKeyspace#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/keyspaces_keyspace#tags_all KeyspacesKeyspace#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/keyspaces_keyspace#timeouts KeyspacesKeyspace#timeouts}
    */
    readonly timeouts?: KeyspacesKeyspaceTimeouts;
}
export interface KeyspacesKeyspaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/keyspaces_keyspace#create KeyspacesKeyspace#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/keyspaces_keyspace#delete KeyspacesKeyspace#delete}
    */
    readonly delete?: string;
}
export declare function keyspacesKeyspaceTimeoutsToTerraform(struct?: KeyspacesKeyspaceTimeoutsOutputReference | KeyspacesKeyspaceTimeouts | cdktf.IResolvable): any;
export declare class KeyspacesKeyspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyspacesKeyspaceTimeouts | undefined;
    set internalValue(value: KeyspacesKeyspaceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/keyspaces_keyspace aws_keyspaces_keyspace}
*/
export declare class KeyspacesKeyspace extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_keyspaces_keyspace";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/keyspaces_keyspace aws_keyspaces_keyspace} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KeyspacesKeyspaceConfig
    */
    constructor(scope: Construct, id: string, config: KeyspacesKeyspaceConfig);
    get arn(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): KeyspacesKeyspaceTimeoutsOutputReference;
    putTimeouts(value: KeyspacesKeyspaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): KeyspacesKeyspaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=keyspaces-keyspace.d.ts.map