import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Kinesis
*/
export interface DataAwsKinesisStreamConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/kinesis_stream#name DataAwsKinesisStream#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/kinesis_stream#tags DataAwsKinesisStream#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataAwsKinesisStreamStreamModeDetails {
}
export declare function dataAwsKinesisStreamStreamModeDetailsToTerraform(struct?: DataAwsKinesisStreamStreamModeDetails): any;
export declare class DataAwsKinesisStreamStreamModeDetailsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsKinesisStreamStreamModeDetails | undefined;
    set internalValue(value: DataAwsKinesisStreamStreamModeDetails | undefined);
    get streamMode(): string;
}
export declare class DataAwsKinesisStreamStreamModeDetailsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsKinesisStreamStreamModeDetailsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/kinesis_stream aws_kinesis_stream}
*/
export declare class DataAwsKinesisStream extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_kinesis_stream";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/kinesis_stream aws_kinesis_stream} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsKinesisStreamConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsKinesisStreamConfig);
    get arn(): string;
    get closedShards(): string[];
    get creationTimestamp(): number;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get openShards(): string[];
    get retentionPeriod(): number;
    get shardLevelMetrics(): string[];
    get status(): string;
    private _streamModeDetails;
    get streamModeDetails(): DataAwsKinesisStreamStreamModeDetailsList;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-kinesis-stream.d.ts.map