import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Kinesis
*/
export interface Kinesisanalyticsv2ApplicationSnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/kinesisanalyticsv2_application_snapshot#application_name Kinesisanalyticsv2ApplicationSnapshot#application_name}
    */
    readonly applicationName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/kinesisanalyticsv2_application_snapshot#snapshot_name Kinesisanalyticsv2ApplicationSnapshot#snapshot_name}
    */
    readonly snapshotName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/kinesisanalyticsv2_application_snapshot#timeouts Kinesisanalyticsv2ApplicationSnapshot#timeouts}
    */
    readonly timeouts?: Kinesisanalyticsv2ApplicationSnapshotTimeouts;
}
export interface Kinesisanalyticsv2ApplicationSnapshotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/kinesisanalyticsv2_application_snapshot#create Kinesisanalyticsv2ApplicationSnapshot#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/kinesisanalyticsv2_application_snapshot#delete Kinesisanalyticsv2ApplicationSnapshot#delete}
    */
    readonly delete?: string;
}
export declare function kinesisanalyticsv2ApplicationSnapshotTimeoutsToTerraform(struct?: Kinesisanalyticsv2ApplicationSnapshotTimeoutsOutputReference | Kinesisanalyticsv2ApplicationSnapshotTimeouts | cdktf.IResolvable): any;
export declare class Kinesisanalyticsv2ApplicationSnapshotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): Kinesisanalyticsv2ApplicationSnapshotTimeouts | undefined;
    set internalValue(value: Kinesisanalyticsv2ApplicationSnapshotTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/kinesisanalyticsv2_application_snapshot aws_kinesisanalyticsv2_application_snapshot}
*/
export declare class Kinesisanalyticsv2ApplicationSnapshot extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_kinesisanalyticsv2_application_snapshot";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/kinesisanalyticsv2_application_snapshot aws_kinesisanalyticsv2_application_snapshot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options Kinesisanalyticsv2ApplicationSnapshotConfig
    */
    constructor(scope: Construct, id: string, config: Kinesisanalyticsv2ApplicationSnapshotConfig);
    private _applicationName?;
    get applicationName(): string;
    set applicationName(value: string);
    get applicationNameInput(): string | undefined;
    get applicationVersionId(): number;
    get id(): string;
    get snapshotCreationTimestamp(): string;
    private _snapshotName?;
    get snapshotName(): string;
    set snapshotName(value: string);
    get snapshotNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): Kinesisanalyticsv2ApplicationSnapshotTimeoutsOutputReference;
    putTimeouts(value: Kinesisanalyticsv2ApplicationSnapshotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): Kinesisanalyticsv2ApplicationSnapshotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=kinesisanalyticsv2-application-snapshot.d.ts.map