import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Key Management Service
*/
export interface DataAwsKmsKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/kms_key#grant_tokens DataAwsKmsKey#grant_tokens}
    */
    readonly grantTokens?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/kms_key#key_id DataAwsKmsKey#key_id}
    */
    readonly keyId: string;
}
export interface DataAwsKmsKeyMultiRegionConfigurationPrimaryKey {
}
export declare function dataAwsKmsKeyMultiRegionConfigurationPrimaryKeyToTerraform(struct?: DataAwsKmsKeyMultiRegionConfigurationPrimaryKey): any;
export declare class DataAwsKmsKeyMultiRegionConfigurationPrimaryKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsKmsKeyMultiRegionConfigurationPrimaryKey | undefined;
    set internalValue(value: DataAwsKmsKeyMultiRegionConfigurationPrimaryKey | undefined);
    get arn(): string;
    get region(): string;
}
export declare class DataAwsKmsKeyMultiRegionConfigurationPrimaryKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsKmsKeyMultiRegionConfigurationPrimaryKeyOutputReference;
}
export interface DataAwsKmsKeyMultiRegionConfigurationReplicaKeys {
}
export declare function dataAwsKmsKeyMultiRegionConfigurationReplicaKeysToTerraform(struct?: DataAwsKmsKeyMultiRegionConfigurationReplicaKeys): any;
export declare class DataAwsKmsKeyMultiRegionConfigurationReplicaKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsKmsKeyMultiRegionConfigurationReplicaKeys | undefined;
    set internalValue(value: DataAwsKmsKeyMultiRegionConfigurationReplicaKeys | undefined);
    get arn(): string;
    get region(): string;
}
export declare class DataAwsKmsKeyMultiRegionConfigurationReplicaKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsKmsKeyMultiRegionConfigurationReplicaKeysOutputReference;
}
export interface DataAwsKmsKeyMultiRegionConfiguration {
}
export declare function dataAwsKmsKeyMultiRegionConfigurationToTerraform(struct?: DataAwsKmsKeyMultiRegionConfiguration): any;
export declare class DataAwsKmsKeyMultiRegionConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsKmsKeyMultiRegionConfiguration | undefined;
    set internalValue(value: DataAwsKmsKeyMultiRegionConfiguration | undefined);
    get multiRegionKeyType(): string;
    private _primaryKey;
    get primaryKey(): DataAwsKmsKeyMultiRegionConfigurationPrimaryKeyList;
    private _replicaKeys;
    get replicaKeys(): DataAwsKmsKeyMultiRegionConfigurationReplicaKeysList;
}
export declare class DataAwsKmsKeyMultiRegionConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsKmsKeyMultiRegionConfigurationOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/kms_key aws_kms_key}
*/
export declare class DataAwsKmsKey extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_kms_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/kms_key aws_kms_key} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsKmsKeyConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsKmsKeyConfig);
    get arn(): string;
    get awsAccountId(): string;
    get creationDate(): string;
    get customerMasterKeySpec(): string;
    get deletionDate(): string;
    get description(): string;
    get enabled(): cdktf.IResolvable;
    get expirationModel(): string;
    private _grantTokens?;
    get grantTokens(): string[];
    set grantTokens(value: string[]);
    resetGrantTokens(): void;
    get grantTokensInput(): string[] | undefined;
    get id(): string;
    private _keyId?;
    get keyId(): string;
    set keyId(value: string);
    get keyIdInput(): string | undefined;
    get keyManager(): string;
    get keyState(): string;
    get keyUsage(): string;
    get multiRegion(): cdktf.IResolvable;
    private _multiRegionConfiguration;
    get multiRegionConfiguration(): DataAwsKmsKeyMultiRegionConfigurationList;
    get origin(): string;
    get validTo(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-kms-key.d.ts.map