import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Lake Formation
*/
export interface LakeformationDataLakeSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/lakeformation_data_lake_settings#admins LakeformationDataLakeSettings#admins}
    */
    readonly admins?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/lakeformation_data_lake_settings#catalog_id LakeformationDataLakeSettings#catalog_id}
    */
    readonly catalogId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/lakeformation_data_lake_settings#trusted_resource_owners LakeformationDataLakeSettings#trusted_resource_owners}
    */
    readonly trustedResourceOwners?: string[];
    /**
    * create_database_default_permissions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/lakeformation_data_lake_settings#create_database_default_permissions LakeformationDataLakeSettings#create_database_default_permissions}
    */
    readonly createDatabaseDefaultPermissions?: LakeformationDataLakeSettingsCreateDatabaseDefaultPermissions[] | cdktf.IResolvable;
    /**
    * create_table_default_permissions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/lakeformation_data_lake_settings#create_table_default_permissions LakeformationDataLakeSettings#create_table_default_permissions}
    */
    readonly createTableDefaultPermissions?: LakeformationDataLakeSettingsCreateTableDefaultPermissions[] | cdktf.IResolvable;
}
export interface LakeformationDataLakeSettingsCreateDatabaseDefaultPermissions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/lakeformation_data_lake_settings#permissions LakeformationDataLakeSettings#permissions}
    */
    readonly permissions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/lakeformation_data_lake_settings#principal LakeformationDataLakeSettings#principal}
    */
    readonly principal?: string;
}
export declare function lakeformationDataLakeSettingsCreateDatabaseDefaultPermissionsToTerraform(struct?: LakeformationDataLakeSettingsCreateDatabaseDefaultPermissions | cdktf.IResolvable): any;
export interface LakeformationDataLakeSettingsCreateTableDefaultPermissions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/lakeformation_data_lake_settings#permissions LakeformationDataLakeSettings#permissions}
    */
    readonly permissions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/lakeformation_data_lake_settings#principal LakeformationDataLakeSettings#principal}
    */
    readonly principal?: string;
}
export declare function lakeformationDataLakeSettingsCreateTableDefaultPermissionsToTerraform(struct?: LakeformationDataLakeSettingsCreateTableDefaultPermissions | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/lakeformation_data_lake_settings aws_lakeformation_data_lake_settings}
*/
export declare class LakeformationDataLakeSettings extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_lakeformation_data_lake_settings";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/lakeformation_data_lake_settings aws_lakeformation_data_lake_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LakeformationDataLakeSettingsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: LakeformationDataLakeSettingsConfig);
    private _admins?;
    get admins(): string[];
    set admins(value: string[]);
    resetAdmins(): void;
    get adminsInput(): string[] | undefined;
    private _catalogId?;
    get catalogId(): string;
    set catalogId(value: string);
    resetCatalogId(): void;
    get catalogIdInput(): string | undefined;
    get id(): string;
    private _trustedResourceOwners?;
    get trustedResourceOwners(): string[];
    set trustedResourceOwners(value: string[]);
    resetTrustedResourceOwners(): void;
    get trustedResourceOwnersInput(): string[] | undefined;
    private _createDatabaseDefaultPermissions?;
    get createDatabaseDefaultPermissions(): LakeformationDataLakeSettingsCreateDatabaseDefaultPermissions[] | cdktf.IResolvable;
    set createDatabaseDefaultPermissions(value: LakeformationDataLakeSettingsCreateDatabaseDefaultPermissions[] | cdktf.IResolvable);
    resetCreateDatabaseDefaultPermissions(): void;
    get createDatabaseDefaultPermissionsInput(): cdktf.IResolvable | LakeformationDataLakeSettingsCreateDatabaseDefaultPermissions[] | undefined;
    private _createTableDefaultPermissions?;
    get createTableDefaultPermissions(): LakeformationDataLakeSettingsCreateTableDefaultPermissions[] | cdktf.IResolvable;
    set createTableDefaultPermissions(value: LakeformationDataLakeSettingsCreateTableDefaultPermissions[] | cdktf.IResolvable);
    resetCreateTableDefaultPermissions(): void;
    get createTableDefaultPermissionsInput(): cdktf.IResolvable | LakeformationDataLakeSettingsCreateTableDefaultPermissions[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=lakeformation-data-lake-settings.d.ts.map