"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LakeformationDataLakeSettings = exports.lakeformationDataLakeSettingsCreateTableDefaultPermissionsToTerraform = exports.lakeformationDataLakeSettingsCreateDatabaseDefaultPermissionsToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function lakeformationDataLakeSettingsCreateDatabaseDefaultPermissionsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        permissions: cdktf.listMapper(cdktf.stringToTerraform)(struct.permissions),
        principal: cdktf.stringToTerraform(struct.principal),
    };
}
exports.lakeformationDataLakeSettingsCreateDatabaseDefaultPermissionsToTerraform = lakeformationDataLakeSettingsCreateDatabaseDefaultPermissionsToTerraform;
function lakeformationDataLakeSettingsCreateTableDefaultPermissionsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        permissions: cdktf.listMapper(cdktf.stringToTerraform)(struct.permissions),
        principal: cdktf.stringToTerraform(struct.principal),
    };
}
exports.lakeformationDataLakeSettingsCreateTableDefaultPermissionsToTerraform = lakeformationDataLakeSettingsCreateTableDefaultPermissionsToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/lakeformation_data_lake_settings aws_lakeformation_data_lake_settings}
*/
class LakeformationDataLakeSettings extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/lakeformation_data_lake_settings aws_lakeformation_data_lake_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LakeformationDataLakeSettingsConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'aws_lakeformation_data_lake_settings',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._admins = config.admins;
        this._catalogId = config.catalogId;
        this._trustedResourceOwners = config.trustedResourceOwners;
        this._createDatabaseDefaultPermissions = config.createDatabaseDefaultPermissions;
        this._createTableDefaultPermissions = config.createTableDefaultPermissions;
    }
    get admins() {
        return cdktf.Fn.tolist(this.getListAttribute('admins'));
    }
    set admins(value) {
        this._admins = value;
    }
    resetAdmins() {
        this._admins = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get adminsInput() {
        return this._admins;
    }
    get catalogId() {
        return this.getStringAttribute('catalog_id');
    }
    set catalogId(value) {
        this._catalogId = value;
    }
    resetCatalogId() {
        this._catalogId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get catalogIdInput() {
        return this._catalogId;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get trustedResourceOwners() {
        return this.getListAttribute('trusted_resource_owners');
    }
    set trustedResourceOwners(value) {
        this._trustedResourceOwners = value;
    }
    resetTrustedResourceOwners() {
        this._trustedResourceOwners = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get trustedResourceOwnersInput() {
        return this._trustedResourceOwners;
    }
    get createDatabaseDefaultPermissions() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('create_database_default_permissions');
    }
    set createDatabaseDefaultPermissions(value) {
        this._createDatabaseDefaultPermissions = value;
    }
    resetCreateDatabaseDefaultPermissions() {
        this._createDatabaseDefaultPermissions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createDatabaseDefaultPermissionsInput() {
        return this._createDatabaseDefaultPermissions;
    }
    get createTableDefaultPermissions() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('create_table_default_permissions');
    }
    set createTableDefaultPermissions(value) {
        this._createTableDefaultPermissions = value;
    }
    resetCreateTableDefaultPermissions() {
        this._createTableDefaultPermissions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createTableDefaultPermissionsInput() {
        return this._createTableDefaultPermissions;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            admins: cdktf.listMapper(cdktf.stringToTerraform)(this._admins),
            catalog_id: cdktf.stringToTerraform(this._catalogId),
            trusted_resource_owners: cdktf.listMapper(cdktf.stringToTerraform)(this._trustedResourceOwners),
            create_database_default_permissions: cdktf.listMapper(lakeformationDataLakeSettingsCreateDatabaseDefaultPermissionsToTerraform)(this._createDatabaseDefaultPermissions),
            create_table_default_permissions: cdktf.listMapper(lakeformationDataLakeSettingsCreateTableDefaultPermissionsToTerraform)(this._createTableDefaultPermissions),
        };
    }
}
exports.LakeformationDataLakeSettings = LakeformationDataLakeSettings;
_a = JSII_RTTI_SYMBOL_1;
LakeformationDataLakeSettings[_a] = { fqn: "@cdktf/provider-aws.lakeformation.LakeformationDataLakeSettings", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
LakeformationDataLakeSettings.tfResourceType = "aws_lakeformation_data_lake_settings";
//# sourceMappingURL=data:application/json;base64,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