import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Lex
*/
export interface DataAwsLexBotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/lex_bot#name DataAwsLexBot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/lex_bot#version DataAwsLexBot#version}
    */
    readonly version?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/lex_bot aws_lex_bot}
*/
export declare class DataAwsLexBot extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_lex_bot";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/lex_bot aws_lex_bot} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsLexBotConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsLexBotConfig);
    get arn(): string;
    get checksum(): string;
    get childDirected(): cdktf.IResolvable;
    get createdDate(): string;
    get description(): string;
    get detectSentiment(): cdktf.IResolvable;
    get enableModelImprovements(): cdktf.IResolvable;
    get failureReason(): string;
    get id(): string;
    get idleSessionTtlInSeconds(): number;
    get lastUpdatedDate(): string;
    get locale(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nluIntentConfidenceThreshold(): number;
    get status(): string;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    get voiceId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-lex-bot.d.ts.map