import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS License Manager
*/
export interface LicensemanagerAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/licensemanager_association#license_configuration_arn LicensemanagerAssociation#license_configuration_arn}
    */
    readonly licenseConfigurationArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/licensemanager_association#resource_arn LicensemanagerAssociation#resource_arn}
    */
    readonly resourceArn: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/licensemanager_association aws_licensemanager_association}
*/
export declare class LicensemanagerAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_licensemanager_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/licensemanager_association aws_licensemanager_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LicensemanagerAssociationConfig
    */
    constructor(scope: Construct, id: string, config: LicensemanagerAssociationConfig);
    get id(): string;
    private _licenseConfigurationArn?;
    get licenseConfigurationArn(): string;
    set licenseConfigurationArn(value: string);
    get licenseConfigurationArnInput(): string | undefined;
    private _resourceArn?;
    get resourceArn(): string;
    set resourceArn(value: string);
    get resourceArnInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=licensemanager-association.d.ts.map