import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Lightsail
*/
export interface LightsailStaticIpAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/lightsail_static_ip_attachment#instance_name LightsailStaticIpAttachment#instance_name}
    */
    readonly instanceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/lightsail_static_ip_attachment#static_ip_name LightsailStaticIpAttachment#static_ip_name}
    */
    readonly staticIpName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/lightsail_static_ip_attachment aws_lightsail_static_ip_attachment}
*/
export declare class LightsailStaticIpAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_lightsail_static_ip_attachment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/lightsail_static_ip_attachment aws_lightsail_static_ip_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LightsailStaticIpAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: LightsailStaticIpAttachmentConfig);
    get id(): string;
    private _instanceName?;
    get instanceName(): string;
    set instanceName(value: string);
    get instanceNameInput(): string | undefined;
    get ipAddress(): string;
    private _staticIpName?;
    get staticIpName(): string;
    set staticIpName(value: string);
    get staticIpNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=lightsail-static-ip-attachment.d.ts.map