import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Macie
*/
export interface MacieMemberAccountAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/macie_member_account_association#member_account_id MacieMemberAccountAssociation#member_account_id}
    */
    readonly memberAccountId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/macie_member_account_association aws_macie_member_account_association}
*/
export declare class MacieMemberAccountAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_macie_member_account_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/macie_member_account_association aws_macie_member_account_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MacieMemberAccountAssociationConfig
    */
    constructor(scope: Construct, id: string, config: MacieMemberAccountAssociationConfig);
    get id(): string;
    private _memberAccountId?;
    get memberAccountId(): string;
    set memberAccountId(value: string);
    get memberAccountIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=macie-member-account-association.d.ts.map