import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* Media Package
*/
export interface MediaPackageChannelConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/media_package_channel#channel_id MediaPackageChannel#channel_id}
    */
    readonly channelId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/media_package_channel#description MediaPackageChannel#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/media_package_channel#tags MediaPackageChannel#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/media_package_channel#tags_all MediaPackageChannel#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
}
export interface MediaPackageChannelHlsIngestIngestEndpoints {
}
export declare function mediaPackageChannelHlsIngestIngestEndpointsToTerraform(struct?: MediaPackageChannelHlsIngestIngestEndpoints): any;
export declare class MediaPackageChannelHlsIngestIngestEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaPackageChannelHlsIngestIngestEndpoints | undefined;
    set internalValue(value: MediaPackageChannelHlsIngestIngestEndpoints | undefined);
    get password(): string;
    get url(): string;
    get username(): string;
}
export declare class MediaPackageChannelHlsIngestIngestEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaPackageChannelHlsIngestIngestEndpointsOutputReference;
}
export interface MediaPackageChannelHlsIngest {
}
export declare function mediaPackageChannelHlsIngestToTerraform(struct?: MediaPackageChannelHlsIngest): any;
export declare class MediaPackageChannelHlsIngestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaPackageChannelHlsIngest | undefined;
    set internalValue(value: MediaPackageChannelHlsIngest | undefined);
    private _ingestEndpoints;
    get ingestEndpoints(): MediaPackageChannelHlsIngestIngestEndpointsList;
}
export declare class MediaPackageChannelHlsIngestList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaPackageChannelHlsIngestOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/media_package_channel aws_media_package_channel}
*/
export declare class MediaPackageChannel extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_media_package_channel";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/media_package_channel aws_media_package_channel} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MediaPackageChannelConfig
    */
    constructor(scope: Construct, id: string, config: MediaPackageChannelConfig);
    get arn(): string;
    private _channelId?;
    get channelId(): string;
    set channelId(value: string);
    get channelIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _hlsIngest;
    get hlsIngest(): MediaPackageChannelHlsIngestList;
    get id(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=media-package-channel.d.ts.map