import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Managed Message Queue
*/
export interface DataAwsMqBrokerInstanceTypeOfferingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/mq_broker_instance_type_offerings#engine_type DataAwsMqBrokerInstanceTypeOfferings#engine_type}
    */
    readonly engineType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/mq_broker_instance_type_offerings#host_instance_type DataAwsMqBrokerInstanceTypeOfferings#host_instance_type}
    */
    readonly hostInstanceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/mq_broker_instance_type_offerings#storage_type DataAwsMqBrokerInstanceTypeOfferings#storage_type}
    */
    readonly storageType?: string;
}
export interface DataAwsMqBrokerInstanceTypeOfferingsBrokerInstanceOptionsAvailabilityZones {
}
export declare function dataAwsMqBrokerInstanceTypeOfferingsBrokerInstanceOptionsAvailabilityZonesToTerraform(struct?: DataAwsMqBrokerInstanceTypeOfferingsBrokerInstanceOptionsAvailabilityZones): any;
export declare class DataAwsMqBrokerInstanceTypeOfferingsBrokerInstanceOptionsAvailabilityZonesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsMqBrokerInstanceTypeOfferingsBrokerInstanceOptionsAvailabilityZones | undefined;
    set internalValue(value: DataAwsMqBrokerInstanceTypeOfferingsBrokerInstanceOptionsAvailabilityZones | undefined);
    get name(): string;
}
export declare class DataAwsMqBrokerInstanceTypeOfferingsBrokerInstanceOptionsAvailabilityZonesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsMqBrokerInstanceTypeOfferingsBrokerInstanceOptionsAvailabilityZonesOutputReference;
}
export interface DataAwsMqBrokerInstanceTypeOfferingsBrokerInstanceOptions {
}
export declare function dataAwsMqBrokerInstanceTypeOfferingsBrokerInstanceOptionsToTerraform(struct?: DataAwsMqBrokerInstanceTypeOfferingsBrokerInstanceOptions): any;
export declare class DataAwsMqBrokerInstanceTypeOfferingsBrokerInstanceOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsMqBrokerInstanceTypeOfferingsBrokerInstanceOptions | undefined;
    set internalValue(value: DataAwsMqBrokerInstanceTypeOfferingsBrokerInstanceOptions | undefined);
    private _availabilityZones;
    get availabilityZones(): DataAwsMqBrokerInstanceTypeOfferingsBrokerInstanceOptionsAvailabilityZonesList;
    get engineType(): string;
    get hostInstanceType(): string;
    get storageType(): string;
    get supportedDeploymentModes(): string[];
    get supportedEngineVersions(): string[];
}
export declare class DataAwsMqBrokerInstanceTypeOfferingsBrokerInstanceOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsMqBrokerInstanceTypeOfferingsBrokerInstanceOptionsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/mq_broker_instance_type_offerings aws_mq_broker_instance_type_offerings}
*/
export declare class DataAwsMqBrokerInstanceTypeOfferings extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_mq_broker_instance_type_offerings";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/mq_broker_instance_type_offerings aws_mq_broker_instance_type_offerings} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsMqBrokerInstanceTypeOfferingsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsMqBrokerInstanceTypeOfferingsConfig);
    private _brokerInstanceOptions;
    get brokerInstanceOptions(): DataAwsMqBrokerInstanceTypeOfferingsBrokerInstanceOptionsList;
    private _engineType?;
    get engineType(): string;
    set engineType(value: string);
    resetEngineType(): void;
    get engineTypeInput(): string | undefined;
    private _hostInstanceType?;
    get hostInstanceType(): string;
    set hostInstanceType(value: string);
    resetHostInstanceType(): void;
    get hostInstanceTypeInput(): string | undefined;
    get id(): string;
    private _storageType?;
    get storageType(): string;
    set storageType(value: string);
    resetStorageType(): void;
    get storageTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-mq-broker-instance-type-offerings.d.ts.map