import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Managed Streaming for Kafka
*/
export interface DataAwsMskBrokerNodesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/msk_broker_nodes#cluster_arn DataAwsMskBrokerNodes#cluster_arn}
    */
    readonly clusterArn: string;
}
export interface DataAwsMskBrokerNodesNodeInfoList {
}
export declare function dataAwsMskBrokerNodesNodeInfoListToTerraform(struct?: DataAwsMskBrokerNodesNodeInfoList): any;
export declare class DataAwsMskBrokerNodesNodeInfoListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsMskBrokerNodesNodeInfoList | undefined;
    set internalValue(value: DataAwsMskBrokerNodesNodeInfoList | undefined);
    get attachedEniId(): string;
    get brokerId(): number;
    get clientSubnet(): string;
    get clientVpcIpAddress(): string;
    get endpoints(): string[];
    get nodeArn(): string;
}
export declare class DataAwsMskBrokerNodesNodeInfoListList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsMskBrokerNodesNodeInfoListOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/msk_broker_nodes aws_msk_broker_nodes}
*/
export declare class DataAwsMskBrokerNodes extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_msk_broker_nodes";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/msk_broker_nodes aws_msk_broker_nodes} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsMskBrokerNodesConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsMskBrokerNodesConfig);
    private _clusterArn?;
    get clusterArn(): string;
    set clusterArn(value: string);
    get clusterArnInput(): string | undefined;
    get id(): string;
    private _nodeInfoList;
    get nodeInfoList(): DataAwsMskBrokerNodesNodeInfoListList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-msk-broker-nodes.d.ts.map