import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Managed Streaming for Kafka
*/
export interface DataAwsMskconnectConnectorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/mskconnect_connector#name DataAwsMskconnectConnector#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/mskconnect_connector aws_mskconnect_connector}
*/
export declare class DataAwsMskconnectConnector extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_mskconnect_connector";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/mskconnect_connector aws_mskconnect_connector} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsMskconnectConnectorConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsMskconnectConnectorConfig);
    get arn(): string;
    get description(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get version(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-mskconnect-connector.d.ts.map