import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OpensearchDomainPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opensearch_domain_policy#access_policies OpensearchDomainPolicy#access_policies}
    */
    readonly accessPolicies: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opensearch_domain_policy#domain_name OpensearchDomainPolicy#domain_name}
    */
    readonly domainName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opensearch_domain_policy#timeouts OpensearchDomainPolicy#timeouts}
    */
    readonly timeouts?: OpensearchDomainPolicyTimeouts;
}
export interface OpensearchDomainPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opensearch_domain_policy#delete OpensearchDomainPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opensearch_domain_policy#update OpensearchDomainPolicy#update}
    */
    readonly update?: string;
}
export declare function opensearchDomainPolicyTimeoutsToTerraform(struct?: OpensearchDomainPolicyTimeoutsOutputReference | OpensearchDomainPolicyTimeouts | cdktf.IResolvable): any;
export declare class OpensearchDomainPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OpensearchDomainPolicyTimeouts | undefined;
    set internalValue(value: OpensearchDomainPolicyTimeouts | undefined);
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/opensearch_domain_policy aws_opensearch_domain_policy}
*/
export declare class OpensearchDomainPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_opensearch_domain_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/opensearch_domain_policy aws_opensearch_domain_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OpensearchDomainPolicyConfig
    */
    constructor(scope: Construct, id: string, config: OpensearchDomainPolicyConfig);
    private _accessPolicies?;
    get accessPolicies(): string;
    set accessPolicies(value: string);
    get accessPoliciesInput(): string | undefined;
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    get id(): string;
    private _timeouts;
    get timeouts(): OpensearchDomainPolicyTimeoutsOutputReference;
    putTimeouts(value: OpensearchDomainPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): OpensearchDomainPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=opensearch-domain-policy.d.ts.map