import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS OpsWorks
*/
export interface OpsworksApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#auto_bundle_on_deploy OpsworksApplication#auto_bundle_on_deploy}
    */
    readonly autoBundleOnDeploy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#aws_flow_ruby_settings OpsworksApplication#aws_flow_ruby_settings}
    */
    readonly awsFlowRubySettings?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#data_source_arn OpsworksApplication#data_source_arn}
    */
    readonly dataSourceArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#data_source_database_name OpsworksApplication#data_source_database_name}
    */
    readonly dataSourceDatabaseName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#data_source_type OpsworksApplication#data_source_type}
    */
    readonly dataSourceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#description OpsworksApplication#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#document_root OpsworksApplication#document_root}
    */
    readonly documentRoot?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#domains OpsworksApplication#domains}
    */
    readonly domains?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#enable_ssl OpsworksApplication#enable_ssl}
    */
    readonly enableSsl?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#name OpsworksApplication#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#rails_env OpsworksApplication#rails_env}
    */
    readonly railsEnv?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#short_name OpsworksApplication#short_name}
    */
    readonly shortName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#stack_id OpsworksApplication#stack_id}
    */
    readonly stackId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#type OpsworksApplication#type}
    */
    readonly type: string;
    /**
    * app_source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#app_source OpsworksApplication#app_source}
    */
    readonly appSource?: OpsworksApplicationAppSource[] | cdktf.IResolvable;
    /**
    * environment block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#environment OpsworksApplication#environment}
    */
    readonly environment?: OpsworksApplicationEnvironment[] | cdktf.IResolvable;
    /**
    * ssl_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#ssl_configuration OpsworksApplication#ssl_configuration}
    */
    readonly sslConfiguration?: OpsworksApplicationSslConfiguration[] | cdktf.IResolvable;
}
export interface OpsworksApplicationAppSource {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#password OpsworksApplication#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#revision OpsworksApplication#revision}
    */
    readonly revision?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#ssh_key OpsworksApplication#ssh_key}
    */
    readonly sshKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#type OpsworksApplication#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#url OpsworksApplication#url}
    */
    readonly url?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#username OpsworksApplication#username}
    */
    readonly username?: string;
}
export declare function opsworksApplicationAppSourceToTerraform(struct?: OpsworksApplicationAppSource | cdktf.IResolvable): any;
export interface OpsworksApplicationEnvironment {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#key OpsworksApplication#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#secure OpsworksApplication#secure}
    */
    readonly secure?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#value OpsworksApplication#value}
    */
    readonly value: string;
}
export declare function opsworksApplicationEnvironmentToTerraform(struct?: OpsworksApplicationEnvironment | cdktf.IResolvable): any;
export interface OpsworksApplicationSslConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#certificate OpsworksApplication#certificate}
    */
    readonly certificate: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#chain OpsworksApplication#chain}
    */
    readonly chain?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application#private_key OpsworksApplication#private_key}
    */
    readonly privateKey: string;
}
export declare function opsworksApplicationSslConfigurationToTerraform(struct?: OpsworksApplicationSslConfiguration | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application aws_opsworks_application}
*/
export declare class OpsworksApplication extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_opsworks_application";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/opsworks_application aws_opsworks_application} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OpsworksApplicationConfig
    */
    constructor(scope: Construct, id: string, config: OpsworksApplicationConfig);
    private _autoBundleOnDeploy?;
    get autoBundleOnDeploy(): string;
    set autoBundleOnDeploy(value: string);
    resetAutoBundleOnDeploy(): void;
    get autoBundleOnDeployInput(): string | undefined;
    private _awsFlowRubySettings?;
    get awsFlowRubySettings(): string;
    set awsFlowRubySettings(value: string);
    resetAwsFlowRubySettings(): void;
    get awsFlowRubySettingsInput(): string | undefined;
    private _dataSourceArn?;
    get dataSourceArn(): string;
    set dataSourceArn(value: string);
    resetDataSourceArn(): void;
    get dataSourceArnInput(): string | undefined;
    private _dataSourceDatabaseName?;
    get dataSourceDatabaseName(): string;
    set dataSourceDatabaseName(value: string);
    resetDataSourceDatabaseName(): void;
    get dataSourceDatabaseNameInput(): string | undefined;
    private _dataSourceType?;
    get dataSourceType(): string;
    set dataSourceType(value: string);
    resetDataSourceType(): void;
    get dataSourceTypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _documentRoot?;
    get documentRoot(): string;
    set documentRoot(value: string);
    resetDocumentRoot(): void;
    get documentRootInput(): string | undefined;
    private _domains?;
    get domains(): string[];
    set domains(value: string[]);
    resetDomains(): void;
    get domainsInput(): string[] | undefined;
    private _enableSsl?;
    get enableSsl(): boolean | cdktf.IResolvable;
    set enableSsl(value: boolean | cdktf.IResolvable);
    resetEnableSsl(): void;
    get enableSslInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _railsEnv?;
    get railsEnv(): string;
    set railsEnv(value: string);
    resetRailsEnv(): void;
    get railsEnvInput(): string | undefined;
    private _shortName?;
    get shortName(): string;
    set shortName(value: string);
    resetShortName(): void;
    get shortNameInput(): string | undefined;
    private _stackId?;
    get stackId(): string;
    set stackId(value: string);
    get stackIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _appSource?;
    get appSource(): OpsworksApplicationAppSource[] | cdktf.IResolvable;
    set appSource(value: OpsworksApplicationAppSource[] | cdktf.IResolvable);
    resetAppSource(): void;
    get appSourceInput(): cdktf.IResolvable | OpsworksApplicationAppSource[] | undefined;
    private _environment?;
    get environment(): OpsworksApplicationEnvironment[] | cdktf.IResolvable;
    set environment(value: OpsworksApplicationEnvironment[] | cdktf.IResolvable);
    resetEnvironment(): void;
    get environmentInput(): cdktf.IResolvable | OpsworksApplicationEnvironment[] | undefined;
    private _sslConfiguration?;
    get sslConfiguration(): OpsworksApplicationSslConfiguration[] | cdktf.IResolvable;
    set sslConfiguration(value: OpsworksApplicationSslConfiguration[] | cdktf.IResolvable);
    resetSslConfiguration(): void;
    get sslConfigurationInput(): cdktf.IResolvable | OpsworksApplicationSslConfiguration[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=opsworks-application.d.ts.map