import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Organizations
*/
export interface DataAwsOrganizationsDelegatedAdministratorsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/organizations_delegated_administrators#service_principal DataAwsOrganizationsDelegatedAdministrators#service_principal}
    */
    readonly servicePrincipal?: string;
}
export interface DataAwsOrganizationsDelegatedAdministratorsDelegatedAdministrators {
}
export declare function dataAwsOrganizationsDelegatedAdministratorsDelegatedAdministratorsToTerraform(struct?: DataAwsOrganizationsDelegatedAdministratorsDelegatedAdministrators): any;
export declare class DataAwsOrganizationsDelegatedAdministratorsDelegatedAdministratorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsOrganizationsDelegatedAdministratorsDelegatedAdministrators | undefined;
    set internalValue(value: DataAwsOrganizationsDelegatedAdministratorsDelegatedAdministrators | undefined);
    get arn(): string;
    get delegationEnabledDate(): string;
    get email(): string;
    get id(): string;
    get joinedMethod(): string;
    get joinedTimestamp(): string;
    get name(): string;
    get status(): string;
}
export declare class DataAwsOrganizationsDelegatedAdministratorsDelegatedAdministratorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsOrganizationsDelegatedAdministratorsDelegatedAdministratorsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/organizations_delegated_administrators aws_organizations_delegated_administrators}
*/
export declare class DataAwsOrganizationsDelegatedAdministrators extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_organizations_delegated_administrators";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/organizations_delegated_administrators aws_organizations_delegated_administrators} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsOrganizationsDelegatedAdministratorsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsOrganizationsDelegatedAdministratorsConfig);
    private _delegatedAdministrators;
    get delegatedAdministrators(): DataAwsOrganizationsDelegatedAdministratorsDelegatedAdministratorsList;
    get id(): string;
    private _servicePrincipal?;
    get servicePrincipal(): string;
    set servicePrincipal(value: string);
    resetServicePrincipal(): void;
    get servicePrincipalInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-organizations-delegated-administrators.d.ts.map