import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Organizations
*/
export interface DataAwsOrganizationsDelegatedServicesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/organizations_delegated_services#account_id DataAwsOrganizationsDelegatedServices#account_id}
    */
    readonly accountId: string;
}
export interface DataAwsOrganizationsDelegatedServicesDelegatedServices {
}
export declare function dataAwsOrganizationsDelegatedServicesDelegatedServicesToTerraform(struct?: DataAwsOrganizationsDelegatedServicesDelegatedServices): any;
export declare class DataAwsOrganizationsDelegatedServicesDelegatedServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsOrganizationsDelegatedServicesDelegatedServices | undefined;
    set internalValue(value: DataAwsOrganizationsDelegatedServicesDelegatedServices | undefined);
    get delegationEnabledDate(): string;
    get servicePrincipal(): string;
}
export declare class DataAwsOrganizationsDelegatedServicesDelegatedServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsOrganizationsDelegatedServicesDelegatedServicesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/organizations_delegated_services aws_organizations_delegated_services}
*/
export declare class DataAwsOrganizationsDelegatedServices extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_organizations_delegated_services";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/organizations_delegated_services aws_organizations_delegated_services} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsOrganizationsDelegatedServicesConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsOrganizationsDelegatedServicesConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    get accountIdInput(): string | undefined;
    private _delegatedServices;
    get delegatedServices(): DataAwsOrganizationsDelegatedServicesDelegatedServicesList;
    get id(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-organizations-delegated-services.d.ts.map